/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.randomwalk;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.paths.PathFactory;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.traversal.RandomWalk;
import org.neo4j.gds.traversal.RandomWalkAlgorithmFactory;
import org.neo4j.gds.traversal.RandomWalkStreamConfig;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.randomWalk.stream", description="Random Walk is an algorithm that provides random paths in a graph. It\u2019s similar to how a drunk person traverses a city.", executionMode=ExecutionMode.STREAM)
public class RandomWalkStreamProc
extends AlgoBaseProc<RandomWalk, Stream<long[]>, RandomWalkStreamConfig, RandomWalkResult> {
    static final String DESCRIPTION = "Random Walk is an algorithm that provides random paths in a graph. It\u2019s similar to how a drunk person traverses a city.";

    @Procedure(name="gds.beta.randomWalk.stream", mode=Mode.READ)
    @Description(value="Random Walk is an algorithm that provides random paths in a graph. It\u2019s similar to how a drunk person traverses a city.")
    public Stream<RandomWalkResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration, false, false);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    @Procedure(value="gds.beta.randomWalk.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected RandomWalkStreamConfig newConfig(String username, CypherMapWrapper config) {
        return RandomWalkStreamConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<RandomWalk, RandomWalkStreamConfig> algorithmFactory() {
        return new RandomWalkAlgorithmFactory();
    }

    public ComputationResultConsumer<RandomWalk, Stream<long[]>, RandomWalkStreamConfig, Stream<RandomWalkResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            if (computationResult.graph().isEmpty()) {
                computationResult.graph().release();
                return Stream.empty();
            }
            boolean returnPath = this.callContext.outputFields().anyMatch(field -> StringFormatting.toLowerCaseWithLocale((String)field).equals("path"));
            Function<List, Path> pathCreator = returnPath ? nodes -> PathFactory.create((Transaction)this.procedureTransaction, (List)nodes, (RelationshipType)RelationshipType.withName((String)"NEXT")) : nodes -> null;
            return ((Stream)computationResult.result()).map(nodes -> {
                List<Long> translatedNodes = this.translateInternalToNeoIds((long[])nodes, (IdMap)computationResult.graph());
                Path path = (Path)pathCreator.apply(translatedNodes);
                return new RandomWalkResult(translatedNodes, path);
            });
        };
    }

    private List<Long> translateInternalToNeoIds(long[] nodes, IdMap idMap) {
        ArrayList<Long> translatedNodes = new ArrayList<Long>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            translatedNodes.add(i, idMap.toOriginalNodeId(nodes[i]));
        }
        return translatedNodes;
    }

    public static final class RandomWalkResult {
        public List<Long> nodeIds;
        public Path path;

        RandomWalkResult(List<Long> nodeIds, Path path) {
            this.nodeIds = nodeIds;
            this.path = path;
        }
    }
}

