/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.node2vec;

import org.neo4j.gds.api.properties.nodes.FloatArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.embeddings.node2vec.Node2Vec;
import org.neo4j.gds.embeddings.node2vec.Node2VecBaseConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.ml.core.tensor.FloatVector;

final class Node2VecCompanion {
    static final String DESCRIPTION = "The Node2Vec algorithm computes embeddings for nodes based on random walks.";

    static <CONFIG extends Node2VecBaseConfig> NodePropertyValues nodeProperties(ComputationResult<Node2Vec, HugeObjectArray<FloatVector>, CONFIG> computationResult) {
        final long size = computationResult.graph().nodeCount();
        final HugeObjectArray embeddings = (HugeObjectArray)computationResult.result();
        return new FloatArrayNodePropertyValues(){

            public long size() {
                return size;
            }

            public float[] floatArrayValue(long nodeId) {
                return ((FloatVector)embeddings.get(nodeId)).data();
            }
        };
    }

    private Node2VecCompanion() {
    }
}

