/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.node2vec;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.beta.node2vec.Node2VecCompanion;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.embeddings.node2vec.Node2Vec;
import org.neo4j.gds.embeddings.node2vec.Node2VecAlgorithmFactory;
import org.neo4j.gds.embeddings.node2vec.Node2VecMutateConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.ml.core.tensor.FloatVector;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.node2vec.mutate", description="The Node2Vec algorithm computes embeddings for nodes based on random walks.", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class Node2VecMutateProc
extends MutatePropertyProc<Node2Vec, HugeObjectArray<FloatVector>, MutateResult, Node2VecMutateConfig> {
    @Procedure(value="gds.beta.node2vec.mutate", mode=Mode.READ)
    @Description(value="The Node2Vec algorithm computes embeddings for nodes based on random walks.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.mutate(computationResult);
    }

    @Procedure(value="gds.beta.node2vec.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected Node2VecMutateConfig newConfig(String username, CypherMapWrapper config) {
        return Node2VecMutateConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<Node2Vec, Node2VecMutateConfig> algorithmFactory() {
        return new Node2VecAlgorithmFactory();
    }

    protected NodeProperties nodeProperties(ComputationResult<Node2Vec, HugeObjectArray<FloatVector>, Node2VecMutateConfig> computationResult) {
        return Node2VecCompanion.nodeProperties(computationResult);
    }

    protected MutateResult.Builder resultBuilder(ComputationResult<Node2Vec, HugeObjectArray<FloatVector>, Node2VecMutateConfig> computeResult, ExecutionContext executionContext) {
        return new MutateResult.Builder();
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long nodeCount;
        public final long nodePropertiesWritten;

        MutateResult(long nodeCount, long nodePropertiesWritten, long preProcessingMillis, long computeMillis, long mutateMillis, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, 0L, mutateMillis, configuration);
            this.nodeCount = nodeCount;
            this.nodePropertiesWritten = nodePropertiesWritten;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.nodeCount, this.nodePropertiesWritten, this.preProcessingMillis, this.computeMillis, this.writeMillis, this.config.toMap());
            }
        }
    }
}

