/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.k1coloring;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.WriteProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.beta.k1coloring.K1Coloring;
import org.neo4j.gds.beta.k1coloring.K1ColoringFactory;
import org.neo4j.gds.beta.k1coloring.K1ColoringProc;
import org.neo4j.gds.beta.k1coloring.K1ColoringWriteConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.k1coloring.write", description="The K-1 Coloring algorithm assigns a color to every node in the graph.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class K1ColoringWriteProc
extends WriteProc<K1Coloring, HugeLongArray, WriteResult, K1ColoringWriteConfig> {
    @Procedure(name="gds.beta.k1coloring.write", mode=Mode.WRITE)
    @Description(value="The K-1 Coloring algorithm assigns a color to every node in the graph.")
    public Stream<WriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.write(computationResult);
    }

    @Procedure(value="gds.beta.k1coloring.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected NodeProperties nodeProperties(ComputationResult<K1Coloring, HugeLongArray, K1ColoringWriteConfig> computationResult) {
        return K1ColoringProc.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<WriteResult> resultBuilder(ComputationResult<K1Coloring, HugeLongArray, K1ColoringWriteConfig> computeResult, ExecutionContext executionContext) {
        WriteResult.Builder builder = new WriteResult.Builder(this.callContext, ((K1ColoringWriteConfig)computeResult.config()).concurrency());
        return K1ColoringProc.resultBuilder(builder, computeResult, this.callContext);
    }

    public GraphAlgorithmFactory<K1Coloring, K1ColoringWriteConfig> algorithmFactory() {
        return new K1ColoringFactory();
    }

    protected K1ColoringWriteConfig newConfig(String username, CypherMapWrapper config) {
        return K1ColoringWriteConfig.of((CypherMapWrapper)config);
    }

    public static class WriteResult {
        public static final WriteResult EMPTY = new WriteResult(0L, 0L, 0L, 0L, 0L, 0L, false, null);
        public final long preProcessingMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final long nodeCount;
        public final long colorCount;
        public final long ranIterations;
        public final boolean didConverge;
        public Map<String, Object> configuration;

        WriteResult(long preProcessingMillis, long computeMillis, long writeMillis, long nodeCount, long colorCount, long ranIterations, boolean didConverge, Map<String, Object> configuration) {
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.nodeCount = nodeCount;
            this.colorCount = colorCount;
            this.ranIterations = ranIterations;
            this.didConverge = didConverge;
            this.configuration = configuration;
        }

        static class Builder
        extends K1ColoringProc.K1ColoringResultBuilder<WriteResult> {
            Builder(ProcedureCallContext context, int concurrency) {
                super(context, concurrency);
            }

            protected WriteResult buildResult() {
                return new WriteResult(this.preProcessingMillis, this.computeMillis, this.writeMillis, this.nodeCount, this.colorCount, this.ranIterations, this.didConverge, this.config.toMap());
            }
        }
    }
}

