/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.node2vec;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.WriteProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.beta.node2vec.Node2VecCompanion;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.embeddings.node2vec.Node2Vec;
import org.neo4j.gds.embeddings.node2vec.Node2VecAlgorithmFactory;
import org.neo4j.gds.embeddings.node2vec.Node2VecWriteConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.ml.core.tensor.FloatVector;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.node2vec.write", description="The Node2Vec algorithm computes embeddings for nodes based on random walks.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class Node2VecWriteProc
extends WriteProc<Node2Vec, HugeObjectArray<FloatVector>, WriteResult, Node2VecWriteConfig> {
    @Procedure(value="gds.beta.node2vec.write", mode=Mode.WRITE)
    @Description(value="The Node2Vec algorithm computes embeddings for nodes based on random walks.")
    public Stream<WriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.write(computationResult);
    }

    @Procedure(value="gds.beta.node2vec.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected Node2VecWriteConfig newConfig(String username, CypherMapWrapper config) {
        return Node2VecWriteConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<Node2Vec, Node2VecWriteConfig> algorithmFactory() {
        return new Node2VecAlgorithmFactory();
    }

    protected NodeProperties nodeProperties(ComputationResult<Node2Vec, HugeObjectArray<FloatVector>, Node2VecWriteConfig> computationResult) {
        return Node2VecCompanion.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<WriteResult> resultBuilder(ComputationResult<Node2Vec, HugeObjectArray<FloatVector>, Node2VecWriteConfig> computeResult, ExecutionContext executionContext) {
        return new WriteResult.Builder();
    }

    public static final class WriteResult {
        public final long nodeCount;
        public final long nodePropertiesWritten;
        public final long preProcessingMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final Map<String, Object> configuration;

        WriteResult(long nodeCount, long nodePropertiesWritten, long preProcessingMillis, long computeMillis, long writeMillis, Map<String, Object> configuration) {
            this.nodeCount = nodeCount;
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.configuration = configuration;
        }

        static class Builder
        extends AbstractResultBuilder<WriteResult> {
            Builder() {
            }

            public WriteResult build() {
                return new WriteResult(this.nodeCount, this.nodePropertiesWritten, this.preProcessingMillis, this.computeMillis, this.writeMillis, this.config.toMap());
            }
        }
    }
}

