/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.modularity;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.beta.modularity.ModularityOptimization;
import org.neo4j.gds.beta.modularity.ModularityOptimizationFactory;
import org.neo4j.gds.beta.modularity.ModularityOptimizationProc;
import org.neo4j.gds.beta.modularity.ModularityOptimizationStreamConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.modularityOptimization.stream", description="The Modularity Optimization algorithm groups the nodes in the graph by optimizing the graphs modularity.", executionMode=ExecutionMode.STREAM)
public class ModularityOptimizationStreamProc
extends StreamProc<ModularityOptimization, ModularityOptimization, StreamResult, ModularityOptimizationStreamConfig> {
    @Procedure(name="gds.beta.modularityOptimization.stream", mode=Mode.READ)
    @Description(value="The Modularity Optimization algorithm groups the nodes in the graph by optimizing the graphs modularity.")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.beta.modularityOptimization.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    public GraphAlgorithmFactory<ModularityOptimization, ModularityOptimizationStreamConfig> algorithmFactory() {
        return new ModularityOptimizationFactory();
    }

    protected StreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        return new StreamResult(originalNodeId, nodeProperties.longValue(internalNodeId));
    }

    protected NodeProperties nodeProperties(ComputationResult<ModularityOptimization, ModularityOptimization, ModularityOptimizationStreamConfig> computationResult) {
        return ModularityOptimizationProc.nodeProperties(computationResult, this.allocationTracker());
    }

    protected ModularityOptimizationStreamConfig newConfig(String username, CypherMapWrapper config) {
        return ModularityOptimizationStreamConfig.of((CypherMapWrapper)config);
    }

    public static class StreamResult {
        public final long nodeId;
        public final long communityId;

        public StreamResult(long nodeId, long communityId) {
            this.nodeId = nodeId;
            this.communityId = communityId;
        }
    }
}

