/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.k1coloring;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StatsProc;
import org.neo4j.gds.beta.k1coloring.K1Coloring;
import org.neo4j.gds.beta.k1coloring.K1ColoringFactory;
import org.neo4j.gds.beta.k1coloring.K1ColoringProc;
import org.neo4j.gds.beta.k1coloring.K1ColoringStatsConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.k1coloring.stats", description="The K-1 Coloring algorithm assigns a color to every node in the graph.", executionMode=ExecutionMode.STATS)
public class K1ColoringStatsProc
extends StatsProc<K1Coloring, HugeLongArray, StatsResult, K1ColoringStatsConfig> {
    @Procedure(name="gds.beta.k1coloring.stats", mode=Mode.READ)
    @Description(value="The K-1 Coloring algorithm assigns a color to every node in the graph.")
    public Stream<StatsResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.stats(computationResult);
    }

    @Procedure(value="gds.beta.k1coloring.stats.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected AbstractResultBuilder<StatsResult> resultBuilder(ComputationResult<K1Coloring, HugeLongArray, K1ColoringStatsConfig> computeResult, ExecutionContext executionContext) {
        StatsResult.Builder builder = new StatsResult.Builder(this.callContext, ((K1ColoringStatsConfig)computeResult.config()).concurrency(), this.allocationTracker());
        return K1ColoringProc.resultBuilder(builder, computeResult, this.callContext);
    }

    public GraphAlgorithmFactory<K1Coloring, K1ColoringStatsConfig> algorithmFactory() {
        return new K1ColoringFactory();
    }

    protected K1ColoringStatsConfig newConfig(String username, CypherMapWrapper config) {
        return K1ColoringStatsConfig.of((CypherMapWrapper)config);
    }

    public static class StatsResult {
        public final long preProcessingMillis;
        public final long computeMillis;
        public final long nodeCount;
        public final long colorCount;
        public final long ranIterations;
        public final boolean didConverge;
        public Map<String, Object> configuration;

        StatsResult(long preProcessingMillis, long computeMillis, long nodeCount, long colorCount, long ranIterations, boolean didConverge, Map<String, Object> configuration) {
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.nodeCount = nodeCount;
            this.colorCount = colorCount;
            this.ranIterations = ranIterations;
            this.didConverge = didConverge;
            this.configuration = configuration;
        }

        static class Builder
        extends K1ColoringProc.K1ColoringResultBuilder<StatsResult> {
            Builder(ProcedureCallContext context, int concurrency, AllocationTracker allocationTracker) {
                super(context, concurrency, allocationTracker);
            }

            protected StatsResult buildResult() {
                return new StatsResult(this.preProcessingMillis, this.computeMillis, this.nodeCount, this.colorCount, this.ranIterations, this.didConverge, this.config.toMap());
            }
        }
    }
}

