/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.node2vec;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.beta.node2vec.Node2VecCompanion;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.embeddings.node2vec.Node2Vec;
import org.neo4j.gds.embeddings.node2vec.Node2VecAlgorithmFactory;
import org.neo4j.gds.embeddings.node2vec.Node2VecStreamConfig;
import org.neo4j.gds.ml.core.tensor.FloatVector;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Node2VecStreamProc
extends StreamProc<Node2Vec, HugeObjectArray<FloatVector>, StreamResult, Node2VecStreamConfig> {
    @Procedure(value="gds.beta.node2vec.stream", mode=Mode.READ)
    @Description(value="The Node2Vec algorithm computes embeddings for nodes based on random walks.")
    public Stream<StreamResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        return this.stream(computationResult);
    }

    @Procedure(value="gds.beta.node2vec.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected Node2VecStreamConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return Node2VecStreamConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<Node2Vec, Node2VecStreamConfig> algorithmFactory() {
        return new Node2VecAlgorithmFactory();
    }

    protected NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<Node2Vec, HugeObjectArray<FloatVector>, Node2VecStreamConfig> computationResult) {
        return Node2VecCompanion.nodeProperties(computationResult);
    }

    protected StreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        return new StreamResult(originalNodeId, nodeProperties.floatArrayValue(internalNodeId));
    }

    public static class StreamResult {
        public long nodeId;
        public List<Double> embedding;

        StreamResult(long nodeId, float[] embedding) {
            this.nodeId = nodeId;
            this.embedding = new ArrayList<Double>(embedding.length);
            for (float f : embedding) {
                this.embedding.add(Double.valueOf(f));
            }
        }
    }
}

