/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.k1coloring;

import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.beta.k1coloring.K1Coloring;
import org.neo4j.gds.beta.k1coloring.K1ColoringConfig;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.result.AbstractCommunityResultBuilder;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;

final class K1ColoringProc {
    static final String K1_COLORING_DESCRIPTION = "The K-1 Coloring algorithm assigns a color to every node in the graph.";
    private static final String COLOR_COUNT_FIELD_NAME = "colorCount";

    private K1ColoringProc() {
    }

    static <PROC_RESULT, CONFIG extends K1ColoringConfig> AbstractResultBuilder<PROC_RESULT> resultBuilder(K1ColoringResultBuilder<PROC_RESULT> procResultBuilder, AlgoBaseProc.ComputationResult<K1Coloring, HugeLongArray, CONFIG> computeResult, ProcedureCallContext callContext) {
        if (callContext.outputFields().anyMatch(field -> field.equals(COLOR_COUNT_FIELD_NAME))) {
            procResultBuilder.withColorCount(((K1Coloring)computeResult.algorithm()).usedColors().cardinality());
        }
        return procResultBuilder.withRanIterations(computeResult.isGraphEmpty() ? 0L : ((K1Coloring)computeResult.algorithm()).ranIterations()).withDidConverge(computeResult.isGraphEmpty() ? false : ((K1Coloring)computeResult.algorithm()).didConverge());
    }

    static <CONFIG extends K1ColoringConfig> NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<K1Coloring, HugeLongArray, CONFIG> computeResult) {
        return ((HugeLongArray)computeResult.result()).asNodeProperties();
    }

    static abstract class K1ColoringResultBuilder<PROC_RESULT>
    extends AbstractCommunityResultBuilder<PROC_RESULT> {
        long colorCount = -1L;
        long ranIterations;
        boolean didConverge;

        K1ColoringResultBuilder(ProcedureCallContext callContext, int concurrency, AllocationTracker allocationTracker) {
            super(callContext, concurrency, allocationTracker);
        }

        K1ColoringResultBuilder<PROC_RESULT> withColorCount(long colorCount) {
            this.colorCount = colorCount;
            return this;
        }

        K1ColoringResultBuilder<PROC_RESULT> withRanIterations(long ranIterations) {
            this.ranIterations = ranIterations;
            return this;
        }

        K1ColoringResultBuilder<PROC_RESULT> withDidConverge(boolean didConverge) {
            this.didConverge = didConverge;
            return this;
        }
    }
}

