/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.modularity;

import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.LongNodeProperties;
import org.neo4j.gds.beta.modularity.ModularityOptimization;
import org.neo4j.gds.beta.modularity.ModularityOptimizationConfig;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.nodeproperties.ConsecutiveLongNodeProperties;
import org.neo4j.gds.result.AbstractCommunityResultBuilder;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;

final class ModularityOptimizationProc {
    static final String MODULARITY_OPTIMIZATION_DESCRIPTION = "The Modularity Optimization algorithm groups the nodes in the graph by optimizing the graphs modularity.";

    ModularityOptimizationProc() {
    }

    static <PROC_RESULT, CONFIG extends ModularityOptimizationConfig> AbstractResultBuilder<PROC_RESULT> resultBuilder(ModularityOptimizationResultBuilder<PROC_RESULT> procResultBuilder, AlgoBaseProc.ComputationResult<ModularityOptimization, ModularityOptimization, CONFIG> computeResult) {
        ModularityOptimization result = (ModularityOptimization)computeResult.result();
        return procResultBuilder.withModularity(result.getModularity()).withRanIterations(result.getIterations()).didConverge(result.didConverge()).withCommunityFunction(arg_0 -> ((ModularityOptimization)result).getCommunityId(arg_0)).withConfig(computeResult.config());
    }

    static <CONFIG extends ModularityOptimizationConfig> NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<ModularityOptimization, ModularityOptimization, CONFIG> computationResult, AllocationTracker allocationTracker) {
        LongNodeProperties resultCommunities = ((ModularityOptimization)computationResult.result()).asNodeProperties();
        if (((ModularityOptimizationConfig)computationResult.config()).consecutiveIds()) {
            return new ConsecutiveLongNodeProperties(resultCommunities, computationResult.graph().nodeCount(), allocationTracker);
        }
        return resultCommunities;
    }

    static abstract class ModularityOptimizationResultBuilder<PROC_RESULT>
    extends AbstractCommunityResultBuilder<PROC_RESULT> {
        long ranIterations;
        boolean didConverge;
        double modularity;

        ModularityOptimizationResultBuilder(ProcedureCallContext callContext, int concurrency, AllocationTracker allocationTracker) {
            super(callContext, concurrency, allocationTracker);
        }

        ModularityOptimizationResultBuilder<PROC_RESULT> withRanIterations(long ranIterations) {
            this.ranIterations = ranIterations;
            return this;
        }

        ModularityOptimizationResultBuilder<PROC_RESULT> didConverge(boolean didConverge) {
            this.didConverge = didConverge;
            return this;
        }

        ModularityOptimizationResultBuilder<PROC_RESULT> withModularity(double modularity) {
            this.modularity = modularity;
            return this;
        }
    }
}

