/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.fastrp;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.StatsProc;
import org.neo4j.gds.beta.fastrp.FastRPExtendedFactory;
import org.neo4j.gds.beta.fastrp.FastRPExtendedStatsConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class FastRPExtendedStatsProc
extends StatsProc<FastRP, FastRP.FastRPResult, StatsResult, FastRPExtendedStatsConfig> {
    @Procedure(value="gds.beta.fastRPExtended.stats", mode=Mode.READ)
    @Description(value="The FastRPExtended algorithm produces node embeddings via random projection of nodes and their properties")
    public Stream<StatsResult> stats(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        return this.stats(computationResult);
    }

    @Procedure(value="gds.beta.fastRPExtended.stats.estimate", mode=Mode.READ)
    @Description(value="The FastRPExtended algorithm produces node embeddings via random projection of nodes and their properties")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected AbstractResultBuilder<StatsResult> resultBuilder(AlgoBaseProc.ComputationResult<FastRP, FastRP.FastRPResult, FastRPExtendedStatsConfig> computeResult) {
        return new StatsResult.Builder();
    }

    protected FastRPExtendedStatsConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return FastRPExtendedStatsConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<FastRP, FastRPExtendedStatsConfig> algorithmFactory() {
        return new FastRPExtendedFactory<FastRPExtendedStatsConfig>();
    }

    public static final class StatsResult {
        public final long nodeCount;
        public final long createMillis;
        public final long computeMillis;
        public final Map<String, Object> configuration;

        StatsResult(long nodeCount, long createMillis, long computeMillis, Map<String, Object> config) {
            this.nodeCount = nodeCount;
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.configuration = config;
        }

        static final class Builder
        extends AbstractResultBuilder<StatsResult> {
            Builder() {
            }

            public StatsResult build() {
                return new StatsResult(this.nodeCount, this.createMillis, this.computeMillis, this.config.toMap());
            }
        }
    }
}

