/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.fastrp;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.beta.fastrp.FastRPExtendedCompanion;
import org.neo4j.gds.beta.fastrp.FastRPExtendedFactory;
import org.neo4j.gds.beta.fastrp.FastRPExtendedMutateConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class FastRPExtendedMutateProc
extends MutatePropertyProc<FastRP, FastRP.FastRPResult, MutateResult, FastRPExtendedMutateConfig> {
    @Procedure(value="gds.beta.fastRPExtended.mutate", mode=Mode.READ)
    @Description(value="The FastRPExtended algorithm produces node embeddings via random projection of nodes and their properties")
    public Stream<MutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        return this.mutate(computationResult);
    }

    @Procedure(value="gds.beta.fastRPExtended.mutate.estimate", mode=Mode.READ)
    @Description(value="The FastRPExtended algorithm produces node embeddings via random projection of nodes and their properties")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<FastRP, FastRP.FastRPResult, FastRPExtendedMutateConfig> computationResult) {
        return FastRPExtendedCompanion.getNodeProperties(computationResult);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(AlgoBaseProc.ComputationResult<FastRP, FastRP.FastRPResult, FastRPExtendedMutateConfig> computeResult) {
        return new MutateResult.Builder();
    }

    protected FastRPExtendedMutateConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return FastRPExtendedMutateConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<FastRP, FastRPExtendedMutateConfig> algorithmFactory() {
        return new FastRPExtendedFactory<FastRPExtendedMutateConfig>();
    }

    public static final class MutateResult {
        public final long nodePropertiesWritten;
        public final long mutateMillis;
        public final long nodeCount;
        public final long createMillis;
        public final long computeMillis;
        public final Map<String, Object> configuration;

        MutateResult(long nodeCount, long nodePropertiesWritten, long createMillis, long computeMillis, long mutateMillis, Map<String, Object> config) {
            this.nodeCount = nodeCount;
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.mutateMillis = mutateMillis;
            this.configuration = config;
        }

        static final class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.nodeCount, this.nodePropertiesWritten, this.createMillis, this.computeMillis, this.mutateMillis, this.config.toMap());
            }
        }
    }
}

