/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.fastrp;

import java.util.Collection;
import java.util.List;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.beta.fastrp.FastRPExtendedBaseConfig;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.gds.ml.core.features.FeatureExtraction;

public class FastRPExtendedFactory<CONFIG extends FastRPExtendedBaseConfig>
extends AlgorithmFactory<FastRP, CONFIG> {
    protected String taskName() {
        return "FastRPExtended";
    }

    protected FastRP build(Graph graph, CONFIG configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
        List featureExtractors = FeatureExtraction.propertyExtractors((Graph)graph, (Collection)configuration.featureProperties());
        return new FastRP(graph, configuration, featureExtractors, progressTracker, allocationTracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        return FastRP.memoryEstimation(configuration);
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return Tasks.task((String)this.taskName(), (Task)Tasks.leaf((String)"Initialize Random Vectors", (long)graph.nodeCount()), (Task[])new Task[]{Tasks.iterativeFixed((String)"Propagate embeddings", () -> List.of(Tasks.leaf((String)"Propagate embeddings task", (long)graph.relationshipCount())), (int)config.iterationWeights().size())});
    }
}

