/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.k1coloring;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.WriteProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.beta.k1coloring.K1Coloring;
import org.neo4j.gds.beta.k1coloring.K1ColoringFactory;
import org.neo4j.gds.beta.k1coloring.K1ColoringProc;
import org.neo4j.gds.beta.k1coloring.K1ColoringWriteConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class K1ColoringWriteProc
extends WriteProc<K1Coloring, HugeLongArray, WriteResult, K1ColoringWriteConfig> {
    @Procedure(name="gds.beta.k1coloring.write", mode=Mode.WRITE)
    @Description(value="The K-1 Coloring algorithm assigns a color to every node in the graph.")
    public Stream<WriteResult> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        return this.write(computationResult);
    }

    @Procedure(value="gds.beta.k1coloring.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<K1Coloring, HugeLongArray, K1ColoringWriteConfig> computationResult) {
        return K1ColoringProc.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<WriteResult> resultBuilder(AlgoBaseProc.ComputationResult<K1Coloring, HugeLongArray, K1ColoringWriteConfig> computeResult) {
        WriteResult.Builder builder = new WriteResult.Builder(this.callContext, ((K1ColoringWriteConfig)computeResult.config()).concurrency(), this.allocationTracker());
        return K1ColoringProc.resultBuilder(builder, computeResult, this.callContext);
    }

    protected AlgorithmFactory<K1Coloring, K1ColoringWriteConfig> algorithmFactory() {
        return new K1ColoringFactory();
    }

    protected K1ColoringWriteConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return K1ColoringWriteConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    public static class WriteResult {
        public static final WriteResult EMPTY = new WriteResult(0L, 0L, 0L, 0L, 0L, 0L, false, null);
        public final long createMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final long nodeCount;
        public final long colorCount;
        public final long ranIterations;
        public final boolean didConverge;
        public Map<String, Object> configuration;

        WriteResult(long createMillis, long computeMillis, long writeMillis, long nodeCount, long colorCount, long ranIterations, boolean didConverge, Map<String, Object> configuration) {
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.nodeCount = nodeCount;
            this.colorCount = colorCount;
            this.ranIterations = ranIterations;
            this.didConverge = didConverge;
            this.configuration = configuration;
        }

        static class Builder
        extends K1ColoringProc.K1ColoringResultBuilder<WriteResult> {
            Builder(ProcedureCallContext context, int concurrency, AllocationTracker tracker) {
                super(context, concurrency, tracker);
            }

            protected WriteResult buildResult() {
                return new WriteResult(this.createMillis, this.computeMillis, this.writeMillis, this.nodeCount, this.colorCount, this.ranIterations, this.didConverge, this.config.toMap());
            }
        }
    }
}

