/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.k1coloring;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.beta.k1coloring.K1Coloring;
import org.neo4j.gds.beta.k1coloring.K1ColoringFactory;
import org.neo4j.gds.beta.k1coloring.K1ColoringProc;
import org.neo4j.gds.beta.k1coloring.K1ColoringStreamConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class K1ColoringStreamProc
extends StreamProc<K1Coloring, HugeLongArray, StreamResult, K1ColoringStreamConfig> {
    @Procedure(name="gds.beta.k1coloring.stream", mode=Mode.READ)
    @Description(value="The K-1 Coloring algorithm assigns a color to every node in the graph.")
    public Stream<StreamResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(value="gds.beta.k1coloring.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected K1ColoringStreamConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return K1ColoringStreamConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<K1Coloring, K1ColoringStreamConfig> algorithmFactory() {
        return new K1ColoringFactory();
    }

    protected StreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        return new StreamResult(originalNodeId, nodeProperties.longValue(internalNodeId));
    }

    protected NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<K1Coloring, HugeLongArray, K1ColoringStreamConfig> computationResult) {
        return K1ColoringProc.nodeProperties(computationResult);
    }

    public static class StreamResult {
        public final long nodeId;
        public final long color;

        StreamResult(long nodeId, long color) {
            this.nodeId = nodeId;
            this.color = color;
        }
    }
}

