/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.fastrp;

import java.util.Collection;
import java.util.List;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.beta.fastrp.FastRPExtendedBaseConfig;
import org.neo4j.gds.core.utils.BatchingProgressLogger;
import org.neo4j.gds.core.utils.ProgressLogger;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.ProgressEventTracker;
import org.neo4j.gds.core.utils.progress.v2.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.v2.tasks.Task;
import org.neo4j.gds.core.utils.progress.v2.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.progress.v2.tasks.Tasks;
import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.gds.ml.core.features.FeatureExtraction;
import org.neo4j.logging.Log;

public class FastRPExtendedFactory<CONFIG extends FastRPExtendedBaseConfig>
implements AlgorithmFactory<FastRP, CONFIG> {
    public FastRP build(Graph graph, CONFIG configuration, AllocationTracker tracker, Log log, ProgressEventTracker eventTracker) {
        BatchingProgressLogger progressLogger = new BatchingProgressLogger(log, graph.nodeCount(), "FastRPE", configuration.concurrency(), eventTracker);
        TaskProgressTracker progressTracker = new TaskProgressTracker(this.progressTask(graph, configuration), (ProgressLogger)progressLogger);
        List featureExtractors = FeatureExtraction.propertyExtractors((Graph)graph, (Collection)configuration.featureProperties());
        return new FastRP(graph, configuration, featureExtractors, (ProgressTracker)progressTracker, tracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        return FastRP.memoryEstimation(configuration);
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return Tasks.task((String)"FastRPExtended", (Task)Tasks.leaf((String)"Initialize Random Vectors", (long)graph.nodeCount()), (Task[])new Task[]{Tasks.iterativeFixed((String)"Propagate embeddings", () -> List.of(Tasks.leaf((String)"Propagate embeddings task", (long)graph.relationshipCount())), (int)config.iterationWeights().size())});
    }
}

