/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.fastrp;

import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.FloatArrayNodeProperties;
import org.neo4j.gds.beta.fastrp.FastRPExtendedBaseConfig;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.embeddings.fastrp.FastRP;

final class FastRPExtendedCompanion {
    static final String DESCRIPTION = "The FastRPExtended algorithm produces node embeddings via random projection of nodes and their properties";

    private FastRPExtendedCompanion() {
    }

    static <CONFIG extends FastRPExtendedBaseConfig> NodeProperties getNodeProperties(AlgoBaseProc.ComputationResult<FastRP, FastRP.FastRPResult, CONFIG> computationResult) {
        final long size = computationResult.graph().nodeCount();
        final HugeObjectArray embeddings = ((FastRP.FastRPResult)computationResult.result()).embeddings();
        return new FloatArrayNodeProperties(){

            public long size() {
                return size;
            }

            public float[] floatArrayValue(long nodeId) {
                return (float[])embeddings.get(nodeId);
            }
        };
    }
}

