/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.node2vec;

import org.neo4j.gds.embeddings.node2vec.Node2Vec;
import org.neo4j.gds.embeddings.node2vec.Node2VecBaseConfig;
import org.neo4j.gds.embeddings.node2vec.Vector;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.api.nodeproperties.FloatArrayNodeProperties;
import org.neo4j.graphalgo.core.utils.paged.HugeObjectArray;

final class Node2VecCompanion {
    static final String DESCRIPTION = "The Node2Vec algorithm computes embeddings for nodes based on random walks.";

    static <CONFIG extends Node2VecBaseConfig> NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<Node2Vec, HugeObjectArray<Vector>, CONFIG> computationResult) {
        final long size = computationResult.graph().nodeCount();
        final HugeObjectArray embeddings = (HugeObjectArray)computationResult.result();
        return new FloatArrayNodeProperties(){

            public long size() {
                return size;
            }

            public float[] floatArrayValue(long nodeId) {
                return ((Vector)embeddings.get(nodeId)).data();
            }
        };
    }

    private Node2VecCompanion() {
    }
}

