/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.fastrp;

import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.api.nodeproperties.FloatArrayNodeProperties;
import org.neo4j.graphalgo.beta.fastrp.FastRPExtendedBaseConfig;
import org.neo4j.graphalgo.core.utils.paged.HugeObjectArray;

final class FastRPExtendedCompanion {
    static final String DESCRIPTION = "The FastRPExtended algorithm produces node embeddings via random projection of nodes and their properties";

    private FastRPExtendedCompanion() {
    }

    static <CONFIG extends FastRPExtendedBaseConfig> NodeProperties getNodeProperties(AlgoBaseProc.ComputationResult<FastRP, FastRP.FastRPResult, CONFIG> computationResult) {
        final long size = computationResult.graph().nodeCount();
        final HugeObjectArray embeddings = ((FastRP.FastRPResult)computationResult.result()).embeddings();
        return new FloatArrayNodeProperties(){

            public long size() {
                return size;
            }

            public float[] floatArrayValue(long nodeId) {
                return (float[])embeddings.get(nodeId);
            }
        };
    }
}

