/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.k1coloring;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.StatsProc;
import org.neo4j.graphalgo.beta.k1coloring.K1Coloring;
import org.neo4j.graphalgo.beta.k1coloring.K1ColoringFactory;
import org.neo4j.graphalgo.beta.k1coloring.K1ColoringProc;
import org.neo4j.graphalgo.beta.k1coloring.K1ColoringStatsConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class K1ColoringStatsProc
extends StatsProc<K1Coloring, HugeLongArray, StatsResult, K1ColoringStatsConfig> {
    @Procedure(name="gds.beta.k1coloring.stats", mode=Mode.READ)
    @Description(value="The K-1 Coloring algorithm assigns a color to every node in the graph.")
    public Stream<StatsResult> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        return this.stats(computationResult);
    }

    @Procedure(value="gds.beta.k1coloring.stats.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected AbstractResultBuilder<StatsResult> resultBuilder(AlgoBaseProc.ComputationResult<K1Coloring, HugeLongArray, K1ColoringStatsConfig> computeResult) {
        StatsResult.Builder builder = new StatsResult.Builder(this.callContext, ((K1ColoringStatsConfig)computeResult.config()).concurrency(), this.allocationTracker());
        return K1ColoringProc.resultBuilder(builder, computeResult, this.callContext);
    }

    protected AlgorithmFactory<K1Coloring, K1ColoringStatsConfig> algorithmFactory() {
        return new K1ColoringFactory();
    }

    protected K1ColoringStatsConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return K1ColoringStatsConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    public static class StatsResult {
        public final long createMillis;
        public final long computeMillis;
        public final long nodeCount;
        public final long colorCount;
        public final long ranIterations;
        public final boolean didConverge;
        public Map<String, Object> configuration;

        StatsResult(long createMillis, long computeMillis, long nodeCount, long colorCount, long ranIterations, boolean didConverge, Map<String, Object> configuration) {
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.nodeCount = nodeCount;
            this.colorCount = colorCount;
            this.ranIterations = ranIterations;
            this.didConverge = didConverge;
            this.configuration = configuration;
        }

        static class Builder
        extends K1ColoringProc.K1ColoringResultBuilder<StatsResult> {
            Builder(ProcedureCallContext context, int concurrency, AllocationTracker tracker) {
                super(context, concurrency, tracker);
            }

            protected StatsResult buildResult() {
                return new StatsResult(this.createMillis, this.computeMillis, this.nodeCount, this.colorCount, this.ranIterations, this.didConverge, this.config.toMap());
            }
        }
    }
}

