/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.fastrp;

import java.util.Collection;
import java.util.List;
import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.gds.ml.core.features.FeatureExtraction;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.beta.fastrp.FastRPExtendedBaseConfig;
import org.neo4j.graphalgo.core.utils.BatchingProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.progress.ProgressEventTracker;
import org.neo4j.logging.Log;

public class FastRPExtendedFactory<CONFIG extends FastRPExtendedBaseConfig>
implements AlgorithmFactory<FastRP, CONFIG> {
    public FastRP build(Graph graph, CONFIG configuration, AllocationTracker tracker, Log log, ProgressEventTracker eventTracker) {
        BatchingProgressLogger progressLogger = new BatchingProgressLogger(log, graph.nodeCount(), "FastRPE", configuration.concurrency(), eventTracker);
        List featureExtractors = FeatureExtraction.propertyExtractors((Graph)graph, (Collection)configuration.featureProperties());
        return new FastRP(graph, configuration, featureExtractors, (ProgressLogger)progressLogger, tracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        return FastRP.memoryEstimation(configuration);
    }
}

