/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.node2vec;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.embeddings.node2vec.Node2Vec;
import org.neo4j.gds.embeddings.node2vec.Node2VecAlgorithmFactory;
import org.neo4j.gds.embeddings.node2vec.Node2VecMutateConfig;
import org.neo4j.gds.embeddings.node2vec.Vector;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.MutatePropertyProc;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.beta.node2vec.Node2VecCompanion;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.utils.paged.HugeObjectArray;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.graphalgo.results.StandardMutateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Node2VecMutateProc
extends MutatePropertyProc<Node2Vec, HugeObjectArray<Vector>, MutateResult, Node2VecMutateConfig> {
    @Procedure(value="gds.beta.node2vec.mutate", mode=Mode.READ)
    @Description(value="The Node2Vec algorithm computes embeddings for nodes based on random walks.")
    public Stream<MutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        return this.mutate(computationResult);
    }

    @Procedure(value="gds.beta.node2vec.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected Node2VecMutateConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return Node2VecMutateConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<Node2Vec, Node2VecMutateConfig> algorithmFactory() {
        return new Node2VecAlgorithmFactory();
    }

    protected NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<Node2Vec, HugeObjectArray<Vector>, Node2VecMutateConfig> computationResult) {
        return Node2VecCompanion.nodeProperties(computationResult);
    }

    protected MutateResult.Builder resultBuilder(AlgoBaseProc.ComputationResult<Node2Vec, HugeObjectArray<Vector>, Node2VecMutateConfig> computeResult) {
        return new MutateResult.Builder();
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long nodeCount;
        public final long nodePropertiesWritten;

        MutateResult(long nodeCount, long nodePropertiesWritten, long createMillis, long computeMillis, long mutateMillis, Map<String, Object> configuration) {
            super(createMillis, computeMillis, 0L, mutateMillis, configuration);
            this.nodeCount = nodeCount;
            this.nodePropertiesWritten = nodePropertiesWritten;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.nodeCount, this.nodePropertiesWritten, this.createMillis, this.computeMillis, this.writeMillis, this.config.toMap());
            }
        }
    }
}

