/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.paths.singlesource;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.beta.paths.ShortestPathWriteProc;
import org.neo4j.graphalgo.beta.paths.WriteResult;
import org.neo4j.graphalgo.beta.paths.dijkstra.Dijkstra;
import org.neo4j.graphalgo.beta.paths.dijkstra.DijkstraFactory;
import org.neo4j.graphalgo.beta.paths.dijkstra.config.AllShortestPathsDijkstraWriteConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class AllShortestPathsDijkstraWriteProc
extends ShortestPathWriteProc<Dijkstra, AllShortestPathsDijkstraWriteConfig> {
    @Procedure(name="gds.beta.allShortestPaths.dijkstra.write", mode=Mode.WRITE)
    @Description(value="The Dijkstra shortest path algorithm computes the shortest (weighted) path between one node and any other node in the graph.")
    public Stream<WriteResult> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(name="gds.beta.allShortestPaths.dijkstra.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> writeEstimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected AllShortestPathsDijkstraWriteConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return AllShortestPathsDijkstraWriteConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<Dijkstra, AllShortestPathsDijkstraWriteConfig> algorithmFactory() {
        return DijkstraFactory.singleSource();
    }
}

