/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.paths;

import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.Algorithm;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.beta.paths.PathResult;
import org.neo4j.graphalgo.beta.paths.WritePathOptionsConfig;
import org.neo4j.graphalgo.beta.paths.WriteResult;
import org.neo4j.graphalgo.beta.paths.dijkstra.DijkstraResult;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.WriteRelationshipConfig;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.write.ImmutableRelationship;
import org.neo4j.graphalgo.core.write.RelationshipStreamExporter;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class ShortestPathWriteProc<ALGO extends Algorithm<ALGO, DijkstraResult>, CONFIG extends AlgoBaseConfig & WriteRelationshipConfig>
extends AlgoBaseProc<ALGO, DijkstraResult, CONFIG> {
    protected Stream<WriteResult> write(AlgoBaseProc.ComputationResult<ALGO, DijkstraResult, CONFIG> computationResult) {
        return (Stream)this.runWithExceptionLogging("Write relationships failed", () -> {
            AlgoBaseConfig config = computationResult.config();
            AbstractResultBuilder resultBuilder = new WriteResult.Builder().withCreateMillis(computationResult.createMillis()).withComputeMillis(computationResult.computeMillis()).withConfig(config);
            if (computationResult.isGraphEmpty()) {
                return Stream.of(new WriteResult(computationResult.createMillis(), 0L, 0L, 0L, 0L, config.toMap()));
            }
            Algorithm algorithm = computationResult.algorithm();
            DijkstraResult result = (DijkstraResult)computationResult.result();
            String writeRelationshipType = ((WriteRelationshipConfig)config).writeRelationshipType();
            boolean writeNodeIds = ((WritePathOptionsConfig)config).writeNodeIds();
            boolean writeCosts = ((WritePathOptionsConfig)config).writeCosts();
            Graph graph = computationResult.graph();
            Stream<RelationshipStreamExporter.Relationship> relationshipStream = result.paths().map(pathResult -> ImmutableRelationship.of((long)pathResult.sourceNode(), (long)pathResult.targetNode(), (Value[])ShortestPathWriteProc.createValues((IdMapping)graph, pathResult, writeNodeIds, writeCosts)));
            RelationshipStreamExporter exporter = (RelationshipStreamExporter)RelationshipStreamExporter.builder((GraphDatabaseService)this.api, (IdMapping)computationResult.graph(), relationshipStream, (TerminationFlag)algorithm.getTerminationFlag()).withLog(this.log).build();
            try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((AbstractResultBuilder)resultBuilder).withWriteMillis(arg_0));){
                resultBuilder.withRelationshipsWritten(exporter.write(writeRelationshipType, ShortestPathWriteProc.createKeys(writeNodeIds, writeCosts)));
            }
            return Stream.of((WriteResult)((Object)((Object)resultBuilder.build())));
        });
    }

    private static String[] createKeys(boolean writeNodeIds, boolean writeCosts) {
        if (writeNodeIds && writeCosts) {
            return new String[]{"totalCost", "nodeIds", "costs"};
        }
        if (writeNodeIds) {
            return new String[]{"totalCost", "nodeIds"};
        }
        if (writeCosts) {
            return new String[]{"totalCost", "costs"};
        }
        return new String[]{"totalCost"};
    }

    private static Value[] createValues(IdMapping idMapping, PathResult pathResult, boolean writeNodeIds, boolean writeCosts) {
        if (writeNodeIds && writeCosts) {
            return new Value[]{Values.doubleValue((double)pathResult.totalCost()), Values.longArray((long[])ShortestPathWriteProc.toOriginalIds(idMapping, pathResult.nodeIds())), Values.doubleArray((double[])pathResult.costs())};
        }
        if (writeNodeIds) {
            return new Value[]{Values.doubleValue((double)pathResult.totalCost()), Values.longArray((long[])ShortestPathWriteProc.toOriginalIds(idMapping, pathResult.nodeIds()))};
        }
        if (writeCosts) {
            return new Value[]{Values.doubleValue((double)pathResult.totalCost()), Values.doubleArray((double[])pathResult.costs())};
        }
        return new Value[]{Values.doubleValue((double)pathResult.totalCost())};
    }

    private static long[] toOriginalIds(IdMapping idMapping, long[] internalIds) {
        for (int i = 0; i < internalIds.length; ++i) {
            internalIds[i] = idMapping.toOriginalNodeId(internalIds[i]);
        }
        return internalIds;
    }
}

