/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.paths;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.beta.paths.PathFactory;
import org.neo4j.graphalgo.beta.paths.PathResult;
import org.neo4j.graphalgo.utils.StringFormatting;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;

public final class StreamResult {
    public static final String COST_PROPERTY_NAME = "cost";
    public long index;
    public long sourceNode;
    public long targetNode;
    public double totalCost;
    public List<Long> nodeIds;
    public List<Double> costs;
    public Path path;

    private StreamResult(long index, long sourceNode, long targetNode, double totalCost, List<Long> nodeIds, List<Double> costs, @Nullable Path path) {
        this.index = index;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.totalCost = totalCost;
        this.nodeIds = nodeIds;
        this.costs = costs;
        this.path = path;
    }

    public static class Builder {
        private long relationshipIdOffset = -1L;
        private final IdMapping idMapping;
        private final Transaction transaction;

        public Builder(IdMapping idMapping, Transaction transaction) {
            this.idMapping = idMapping;
            this.transaction = transaction;
        }

        public StreamResult build(PathResult pathResult, boolean createCypherPath) {
            long[] nodeIds = pathResult.nodeIds();
            double[] costs = pathResult.costs();
            long pathIndex = pathResult.index();
            RelationshipType relationshipType = RelationshipType.withName((String)StringFormatting.formatWithLocale((String)"PATH_%d", (Object[])new Object[]{pathIndex}));
            Path path = null;
            if (createCypherPath) {
                path = PathFactory.create((Transaction)this.transaction, (long)this.relationshipIdOffset, (long[])nodeIds, (double[])costs, (RelationshipType)relationshipType, (String)StreamResult.COST_PROPERTY_NAME);
                this.relationshipIdOffset -= (long)path.length();
            }
            ArrayList<Long> nodeIdsList = new ArrayList<Long>(nodeIds.length);
            for (long nodeId : nodeIds) {
                nodeIdsList.add(this.idMapping.toOriginalNodeId(nodeId));
            }
            ArrayList<Double> costsList = new ArrayList<Double>(costs.length);
            for (double cost : costs) {
                costsList.add(cost);
            }
            return new StreamResult(pathIndex, this.idMapping.toOriginalNodeId(pathResult.sourceNode()), this.idMapping.toOriginalNodeId(pathResult.targetNode()), pathResult.totalCost(), nodeIdsList, costsList, path);
        }
    }
}

