/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.paths.sourcetarget;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.beta.paths.MutateResult;
import org.neo4j.graphalgo.beta.paths.ShortestPathMutateProc;
import org.neo4j.graphalgo.beta.paths.yens.Yens;
import org.neo4j.graphalgo.beta.paths.yens.YensFactory;
import org.neo4j.graphalgo.beta.paths.yens.config.ShortestPathYensMutateConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ShortestPathYensMutateProc
extends ShortestPathMutateProc<Yens, ShortestPathYensMutateConfig> {
    @Procedure(name="gds.beta.shortestPath.yens.mutate", mode=Mode.READ)
    @Description(value="The Yen's shortest path algorithm computes the k shortest (weighted) paths between a pair of nodes.")
    public Stream<MutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(name="gds.beta.shortestPath.yens.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> mutateEstimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected ShortestPathYensMutateConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ShortestPathYensMutateConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<Yens, ShortestPathYensMutateConfig> algorithmFactory() {
        return new YensFactory();
    }
}

