/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.paths.sourcetarget;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.beta.paths.ShortestPathWriteProc;
import org.neo4j.graphalgo.beta.paths.WriteResult;
import org.neo4j.graphalgo.beta.paths.astar.AStar;
import org.neo4j.graphalgo.beta.paths.astar.AStarFactory;
import org.neo4j.graphalgo.beta.paths.astar.config.ShortestPathAStarWriteConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ShortestPathAStarWriteProc
extends ShortestPathWriteProc<AStar, ShortestPathAStarWriteConfig> {
    @Procedure(name="gds.beta.shortestPath.astar.write", mode=Mode.WRITE)
    @Description(value="The A* shortest path algorithm computes the shortest path between a pair of nodes. It uses the relationship weight property to compare path lengths. In addition, this implementation uses the haversine distance as a heuristic to converge faster.")
    public Stream<WriteResult> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(name="gds.beta.shortestPath.astar.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> writeEstimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected ShortestPathAStarWriteConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ShortestPathAStarWriteConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<AStar, ShortestPathAStarWriteConfig> algorithmFactory() {
        return new AStarFactory();
    }
}

