/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.paths.singlesource;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.beta.paths.ShortestPathStreamProc;
import org.neo4j.graphalgo.beta.paths.StreamResult;
import org.neo4j.graphalgo.beta.paths.dijkstra.Dijkstra;
import org.neo4j.graphalgo.beta.paths.dijkstra.DijkstraFactory;
import org.neo4j.graphalgo.beta.paths.dijkstra.config.AllShortestPathsDijkstraStreamConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class AllShortestPathsDijkstraStreamProc
extends ShortestPathStreamProc<Dijkstra, AllShortestPathsDijkstraStreamConfig> {
    @Procedure(name="gds.beta.allShortestPaths.dijkstra.stream", mode=Mode.READ)
    @Description(value="The Dijkstra shortest path algorithm computes the shortest (weighted) path between one node and any other node in the graph.")
    public Stream<StreamResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(name="gds.beta.allShortestPaths.dijkstra.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> streamEstimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected AllShortestPathsDijkstraStreamConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return AllShortestPathsDijkstraStreamConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<Dijkstra, AllShortestPathsDijkstraStreamConfig> algorithmFactory() {
        return DijkstraFactory.singleSource();
    }
}

