/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.paths;

import java.util.Optional;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.Algorithm;
import org.neo4j.graphalgo.MutateProc;
import org.neo4j.graphalgo.Orientation;
import org.neo4j.graphalgo.RelationshipType;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.Relationships;
import org.neo4j.graphalgo.beta.paths.MutateResult;
import org.neo4j.graphalgo.beta.paths.dijkstra.DijkstraResult;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.MutateRelationshipConfig;
import org.neo4j.graphalgo.core.loading.construction.GraphFactory;
import org.neo4j.graphalgo.core.loading.construction.RelationshipsBuilder;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.values.storable.NumberType;

public abstract class ShortestPathMutateProc<ALGO extends Algorithm<ALGO, DijkstraResult>, CONFIG extends AlgoBaseConfig & MutateRelationshipConfig>
extends MutateProc<ALGO, DijkstraResult, MutateResult, CONFIG> {
    protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, AlgoBaseProc.ComputationResult<ALGO, DijkstraResult, CONFIG> computationResult) {
        Relationships relationships;
        AlgoBaseConfig config = computationResult.config();
        DijkstraResult result = (DijkstraResult)computationResult.result();
        RelationshipType mutateRelationshipType = RelationshipType.of((String)((MutateRelationshipConfig)config).mutateRelationshipType());
        RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().nodes((IdMapping)computationResult.graph()).loadRelationshipProperty(true).orientation(Orientation.NATURAL).build();
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withMutateMillis(arg_0));){
            result.paths().forEach(pathResult -> relationshipsBuilder.addFromInternal(pathResult.sourceNode(), pathResult.targetNode(), pathResult.totalCost()));
            relationships = relationshipsBuilder.build();
            resultBuilder.withRelationshipsWritten(relationships.topology().elementCount());
        }
        computationResult.graphStore().addRelationshipType(mutateRelationshipType, Optional.of("totalCost"), Optional.of(NumberType.FLOATING_POINT), relationships);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(AlgoBaseProc.ComputationResult<ALGO, DijkstraResult, CONFIG> computeResult) {
        return new MutateResult.Builder().withCreateMillis(computeResult.createMillis()).withComputeMillis(computeResult.computeMillis()).withConfig(computeResult.config());
    }
}

