/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.fastrp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.StreamProc;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.beta.fastrp.FastRPExtendedCompanion;
import org.neo4j.graphalgo.beta.fastrp.FastRPExtendedFactory;
import org.neo4j.graphalgo.beta.fastrp.FastRPExtendedStreamConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class FastRPExtendedStreamProc
extends StreamProc<FastRP, FastRP.FastRPResult, StreamResult, FastRPExtendedStreamConfig> {
    @Procedure(value="gds.beta.fastRPExtended.stream", mode=Mode.READ)
    @Description(value="The FastRPExtended algorithm produces node embeddings via random projection of nodes and their properties")
    public Stream<StreamResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        return this.stream(computationResult);
    }

    @Procedure(value="gds.beta.fastRPExtended.stream.estimate", mode=Mode.READ)
    @Description(value="The FastRPExtended algorithm produces node embeddings via random projection of nodes and their properties")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<FastRP, FastRP.FastRPResult, FastRPExtendedStreamConfig> computationResult) {
        return FastRPExtendedCompanion.getNodeProperties(computationResult);
    }

    protected StreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        return new StreamResult(originalNodeId, nodeProperties.floatArrayValue(internalNodeId));
    }

    protected FastRPExtendedStreamConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return FastRPExtendedStreamConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<FastRP, FastRPExtendedStreamConfig> algorithmFactory() {
        return new FastRPExtendedFactory<FastRPExtendedStreamConfig>();
    }

    public static final class StreamResult {
        public final long nodeId;
        public final List<Number> embedding;

        StreamResult(long nodeId, float[] embedding) {
            this.nodeId = nodeId;
            this.embedding = StreamResult.arrayToList(embedding);
        }

        static List<Number> arrayToList(float[] values) {
            ArrayList<Number> floats = new ArrayList<Number>(values.length);
            for (float value : values) {
                floats.add(Float.valueOf(value));
            }
            return floats;
        }
    }
}

