/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.paths.sourcetarget;

import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.Algorithm;
import org.neo4j.graphalgo.StreamProc;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.beta.paths.PathResult;
import org.neo4j.graphalgo.beta.paths.ReturnsPathConfig;
import org.neo4j.graphalgo.beta.paths.StreamResult;
import org.neo4j.graphalgo.beta.paths.dijkstra.DijkstraResult;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphdb.Transaction;

public abstract class ShortestPathStreamProc<ALGO extends Algorithm<ALGO, DijkstraResult>, CONFIG extends AlgoBaseConfig & ReturnsPathConfig>
extends StreamProc<ALGO, DijkstraResult, StreamResult, CONFIG> {
    protected StreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        throw new UnsupportedOperationException("Shortest path algorithm handles result building individually.");
    }

    public Stream<StreamResult> stream(AlgoBaseProc.ComputationResult<ALGO, DijkstraResult, CONFIG> computationResult) {
        return (Stream)this.runWithExceptionLogging("Result streaming failed", () -> {
            Graph graph = computationResult.graph();
            AlgoBaseConfig config = computationResult.config();
            if (computationResult.isGraphEmpty()) {
                graph.release();
                return Stream.empty();
            }
            StreamResult.Builder resultBuilder = new StreamResult.Builder((IdMapping)graph, (Transaction)this.transaction.internalTransaction());
            return ((DijkstraResult)computationResult.result()).paths().takeWhile(path -> path != PathResult.EMPTY).map(path -> resultBuilder.build((PathResult)path, ((ReturnsPathConfig)config).path()));
        });
    }
}

