/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.paths.sourcetarget;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.beta.paths.StreamResult;
import org.neo4j.graphalgo.beta.paths.dijkstra.Dijkstra;
import org.neo4j.graphalgo.beta.paths.dijkstra.DijkstraFactory;
import org.neo4j.graphalgo.beta.paths.dijkstra.config.ShortestPathDijkstraStreamConfig;
import org.neo4j.graphalgo.beta.paths.sourcetarget.ShortestPathStreamProc;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ShortestPathDijkstraStreamProc
extends ShortestPathStreamProc<Dijkstra, ShortestPathDijkstraStreamConfig> {
    @Procedure(name="gds.beta.shortestPath.dijkstra.stream", mode=Mode.READ)
    @Description(value="The Dijkstra shortest path algorithm computes the shortest (weighted) path between a pair of nodes.")
    public Stream<StreamResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(name="gds.beta.shortestPath.dijkstra.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> streamEstimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected ShortestPathDijkstraStreamConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ShortestPathDijkstraStreamConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<Dijkstra, ShortestPathDijkstraStreamConfig> algorithmFactory() {
        return DijkstraFactory.sourceTarget();
    }
}

