/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.fastrp;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.embeddings.fastrp.FastRP;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.WriteProc;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.beta.fastrp.FastRPExtendedCompanion;
import org.neo4j.graphalgo.beta.fastrp.FastRPExtendedFactory;
import org.neo4j.graphalgo.beta.fastrp.FastRPExtendedWriteConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class FastRPExtendedWriteProc
extends WriteProc<FastRP, FastRP.FastRPResult, WriteResult, FastRPExtendedWriteConfig> {
    @Procedure(value="gds.beta.fastRPExtended.write", mode=Mode.WRITE)
    @Description(value="The FastRPExtended algorithm produces node embeddings via random projection of nodes and their properties")
    public Stream<WriteResult> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        return this.write(computationResult);
    }

    @Procedure(value="gds.beta.fastRPExtended.write.estimate", mode=Mode.READ)
    @Description(value="The FastRPExtended algorithm produces node embeddings via random projection of nodes and their properties")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected FastRPExtendedWriteConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return FastRPExtendedWriteConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<FastRP, FastRPExtendedWriteConfig> algorithmFactory() {
        return new FastRPExtendedFactory<FastRPExtendedWriteConfig>();
    }

    protected NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<FastRP, FastRP.FastRPResult, FastRPExtendedWriteConfig> computationResult) {
        return FastRPExtendedCompanion.getNodeProperties(computationResult);
    }

    protected AbstractResultBuilder<WriteResult> resultBuilder(AlgoBaseProc.ComputationResult<FastRP, FastRP.FastRPResult, FastRPExtendedWriteConfig> computeResult) {
        return new WriteResult.Builder();
    }

    public static final class WriteResult {
        public final long nodeCount;
        public final long nodePropertiesWritten;
        public final long createMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final Map<String, Object> configuration;

        WriteResult(long nodeCount, long nodePropertiesWritten, long createMillis, long computeMillis, long writeMillis, Map<String, Object> configuration) {
            this.nodeCount = nodeCount;
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.configuration = configuration;
        }

        static class Builder
        extends AbstractResultBuilder<WriteResult> {
            Builder() {
            }

            public WriteResult build() {
                return new WriteResult(this.nodeCount, this.nodePropertiesWritten, this.createMillis, this.computeMillis, this.writeMillis, this.config.toMap());
            }
        }
    }
}

