/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.modularity;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.WriteProc;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.beta.modularity.ModularityOptimization;
import org.neo4j.graphalgo.beta.modularity.ModularityOptimizationFactory;
import org.neo4j.graphalgo.beta.modularity.ModularityOptimizationProc;
import org.neo4j.graphalgo.beta.modularity.ModularityOptimizationWriteConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ModularityOptimizationWriteProc
extends WriteProc<ModularityOptimization, ModularityOptimization, WriteResult, ModularityOptimizationWriteConfig> {
    @Procedure(name="gds.beta.modularityOptimization.write", mode=Mode.WRITE)
    @Description(value="The Modularity Optimization algorithm groups the nodes in the graph by optimizing the graphs modularity.")
    public Stream<WriteResult> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(value="gds.beta.modularityOptimization.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected ModularityOptimizationWriteConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ModularityOptimizationWriteConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<ModularityOptimization, ModularityOptimizationWriteConfig> algorithmFactory() {
        return new ModularityOptimizationFactory();
    }

    protected NodeProperties getNodeProperties(AlgoBaseProc.ComputationResult<ModularityOptimization, ModularityOptimization, ModularityOptimizationWriteConfig> computationResult) {
        return ModularityOptimizationProc.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<WriteResult> resultBuilder(AlgoBaseProc.ComputationResult<ModularityOptimization, ModularityOptimization, ModularityOptimizationWriteConfig> computeResult) {
        return ModularityOptimizationProc.resultBuilder(new WriteResult.Builder(this.callContext, computeResult.tracker()), computeResult);
    }

    public static class WriteResult {
        public final long createMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final long postProcessingMillis;
        public final long nodes;
        public boolean didConverge;
        public long ranIterations;
        public double modularity;
        public final long communityCount;
        public final Map<String, Object> communityDistribution;
        public final Map<String, Object> configuration;

        WriteResult(long createMillis, long computeMillis, long postProcessingMillis, long writeMillis, long nodes, boolean didConverge, long ranIterations, double modularity, long communityCount, Map<String, Object> communityDistribution, Map<String, Object> configuration) {
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.postProcessingMillis = postProcessingMillis;
            this.nodes = nodes;
            this.didConverge = didConverge;
            this.ranIterations = ranIterations;
            this.modularity = modularity;
            this.communityCount = communityCount;
            this.communityDistribution = communityDistribution;
            this.configuration = configuration;
        }

        static class Builder
        extends ModularityOptimizationProc.ModularityOptimizationResultBuilder<WriteResult> {
            Builder(ProcedureCallContext context, AllocationTracker tracker) {
                super(context, tracker);
            }

            protected WriteResult buildResult() {
                return new WriteResult(this.createMillis, this.computeMillis, this.postProcessingDuration, this.writeMillis, this.nodeCount, this.didConverge, this.ranIterations, this.modularity, this.maybeCommunityCount.orElse(0L), this.communityHistogramOrNull(), this.config.toMap());
            }
        }
    }
}

