/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.modularity;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.MutateProc;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.beta.modularity.ModularityOptimization;
import org.neo4j.graphalgo.beta.modularity.ModularityOptimizationFactory;
import org.neo4j.graphalgo.beta.modularity.ModularityOptimizationMutateConfig;
import org.neo4j.graphalgo.beta.modularity.ModularityOptimizationProc;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ModularityOptimizationMutateProc
extends MutateProc<ModularityOptimization, ModularityOptimization, MutateResult, ModularityOptimizationMutateConfig> {
    @Procedure(value="gds.beta.modularityOptimization.mutate", mode=Mode.READ)
    @Description(value="The Modularity Optimization algorithm groups the nodes in the graph by optimizing the graphs modularity.")
    public Stream<MutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(value="gds.beta.modularityOptimization.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> mutateEstimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected NodeProperties getNodeProperties(AlgoBaseProc.ComputationResult<ModularityOptimization, ModularityOptimization, ModularityOptimizationMutateConfig> computationResult) {
        return ModularityOptimizationProc.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(AlgoBaseProc.ComputationResult<ModularityOptimization, ModularityOptimization, ModularityOptimizationMutateConfig> computeResult) {
        return ModularityOptimizationProc.resultBuilder(new MutateResult.Builder(this.callContext, computeResult.tracker()), computeResult);
    }

    protected ModularityOptimizationMutateConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ModularityOptimizationMutateConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<ModularityOptimization, ModularityOptimizationMutateConfig> algorithmFactory() {
        return new ModularityOptimizationFactory();
    }

    public static class MutateResult {
        public final long createMillis;
        public final long computeMillis;
        public final long mutateMillis;
        public final long postProcessingMillis;
        public final long nodes;
        public boolean didConverge;
        public long ranIterations;
        public double modularity;
        public final long communityCount;
        public final Map<String, Object> communityDistribution;
        public final Map<String, Object> configuration;

        MutateResult(long createMillis, long computeMillis, long postProcessingMillis, long mutateMillis, long nodes, boolean didConverge, long ranIterations, double modularity, long communityCount, Map<String, Object> communityDistribution, Map<String, Object> configuration) {
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.mutateMillis = mutateMillis;
            this.postProcessingMillis = postProcessingMillis;
            this.nodes = nodes;
            this.didConverge = didConverge;
            this.ranIterations = ranIterations;
            this.modularity = modularity;
            this.communityCount = communityCount;
            this.communityDistribution = communityDistribution;
            this.configuration = configuration;
        }

        static class Builder
        extends ModularityOptimizationProc.ModularityOptimizationResultBuilder<MutateResult> {
            Builder(ProcedureCallContext context, AllocationTracker tracker) {
                super(context, tracker);
            }

            protected MutateResult buildResult() {
                return new MutateResult(this.createMillis, this.computeMillis, this.postProcessingDuration, this.mutateMillis, this.nodeCount, this.didConverge, this.ranIterations, this.modularity, this.maybeCommunityCount.orElse(0L), this.communityHistogramOrNull(), this.config.toMap());
            }
        }
    }
}

