/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel.context;

import java.util.function.LongConsumer;
import org.neo4j.gds.beta.pregel.ComputeStep;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.context.PregelContext;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public abstract class NodeCentricContext<CONFIG extends PregelConfig>
extends PregelContext<CONFIG> {
    protected final ComputeStep<CONFIG, ?> computeStep;
    long nodeId;

    NodeCentricContext(ComputeStep<CONFIG, ?> computeStep, CONFIG config, ProgressTracker progressTracker) {
        super(config, progressTracker);
        this.computeStep = computeStep;
    }

    @Override
    public boolean isMultiGraph() {
        return this.computeStep.isMultiGraph();
    }

    @Override
    public long nodeCount() {
        return this.computeStep.nodeCount();
    }

    @Override
    public long relationshipCount() {
        return this.computeStep.relationshipCount();
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public long nodeId() {
        return this.nodeId;
    }

    public void setNodeValue(String key, double value) {
        this.computeStep.setNodeValue(key, this.nodeId, value);
    }

    public void setNodeValue(String key, long value) {
        this.computeStep.setNodeValue(key, this.nodeId, value);
    }

    public void setNodeValue(String key, long[] value) {
        this.computeStep.setNodeValue(key, this.nodeId, value);
    }

    public void setNodeValue(String key, double[] value) {
        this.computeStep.setNodeValue(key, this.nodeId, value);
    }

    public int degree() {
        return this.computeStep.degree(this.nodeId);
    }

    public long toOriginalId() {
        return this.toOriginalId(this.nodeId());
    }

    public long toOriginalId(long internalNodeId) {
        return this.computeStep.toOriginalNodeId(internalNodeId);
    }

    public long toInternalId(long originalNodeId) {
        return this.computeStep.toInternalNodeId(originalNodeId);
    }

    public void forEachNeighbor(LongConsumer targetConsumer) {
        this.computeStep.forEachNeighbor(this.nodeId, targetConsumer);
    }

    public void forEachNeighbor(long nodeId, LongConsumer targetConsumer) {
        this.computeStep.forEachNeighbor(nodeId, targetConsumer);
    }

    public void forEachDistinctNeighbor(LongConsumer targetConsumer) {
        this.computeStep.forEachDistinctNeighbor(this.nodeId, targetConsumer);
    }

    public void forEachDistinctNeighbor(long nodeId, LongConsumer targetConsumer) {
        this.computeStep.forEachDistinctNeighbor(nodeId, targetConsumer);
    }
}

