/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel.context;

import java.util.concurrent.ExecutorService;
import java.util.function.LongPredicate;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.beta.pregel.NodeValue;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.context.PregelContext;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public class MasterComputeContext<CONFIG extends PregelConfig>
extends PregelContext<CONFIG> {
    private final Graph graph;
    private final int iteration;
    private final NodeValue nodeValue;
    private final ExecutorService executorService;

    public MasterComputeContext(CONFIG config, Graph graph, int iteration, NodeValue nodeValue, ExecutorService executorService, ProgressTracker progressTracker) {
        super(config, progressTracker);
        this.graph = graph;
        this.iteration = iteration;
        this.nodeValue = nodeValue;
        this.executorService = executorService;
    }

    @Override
    public boolean isMultiGraph() {
        return this.graph.isMultiGraph();
    }

    @Override
    public long nodeCount() {
        return this.graph.nodeCount();
    }

    @Override
    public long relationshipCount() {
        return this.graph.relationshipCount();
    }

    public int superstep() {
        return this.iteration;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public boolean isInitialSuperstep() {
        return this.superstep() == 0;
    }

    public long toOriginalId(long internalNodeId) {
        return this.graph.toOriginalNodeId(internalNodeId);
    }

    public long toInternalId(long originalNodeId) {
        return this.graph.toMappedNodeId(originalNodeId);
    }

    public void forEachNode(LongPredicate consumer) {
        this.graph.forEachNode(consumer);
    }

    public double doubleNodeValue(long nodeId, String key) {
        return this.nodeValue.doubleValue(key, nodeId);
    }

    public long longNodeValue(long nodeId, String key) {
        return this.nodeValue.longValue(key, nodeId);
    }

    public long[] longArrayNodeValue(long nodeId, String key) {
        return this.nodeValue.longArrayValue(key, nodeId);
    }

    public double[] doubleArrayNodeValue(long nodeId, String key) {
        return this.nodeValue.doubleArrayValue(key, nodeId);
    }

    public void setNodeValue(long nodeId, String key, double value) {
        this.nodeValue.set(key, nodeId, value);
    }

    public void setNodeValue(long nodeId, String key, long value) {
        this.nodeValue.set(key, nodeId, value);
    }

    public void setNodeValue(long nodeId, String key, long[] value) {
        this.nodeValue.set(key, nodeId, value);
    }

    public void setNodeValue(long nodeId, String key, double[] value) {
        this.nodeValue.set(key, nodeId, value);
    }
}

