/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import org.neo4j.gds.beta.pregel.Messenger;
import org.neo4j.gds.beta.pregel.PrimitiveSyncDoubleQueues;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;

public class SyncQueueMessenger
implements Messenger<PrimitiveSyncDoubleQueues.Iterator> {
    private final PrimitiveSyncDoubleQueues queues;

    SyncQueueMessenger(long nodeCount) {
        this.queues = PrimitiveSyncDoubleQueues.of(nodeCount);
    }

    static MemoryEstimation memoryEstimation() {
        return PrimitiveSyncDoubleQueues.memoryEstimation();
    }

    @Override
    public void initIteration(int iteration) {
        this.queues.swapQueues();
    }

    @Override
    public void sendTo(long targetNodeId, double message) {
        this.queues.push(targetNodeId, message);
    }

    @Override
    public PrimitiveSyncDoubleQueues.Iterator messageIterator() {
        return new PrimitiveSyncDoubleQueues.Iterator();
    }

    @Override
    public void initMessageIterator(PrimitiveSyncDoubleQueues.Iterator messageIterator, long nodeId, boolean isFirstIteration) {
        this.queues.initIterator(messageIterator, nodeId);
    }

    @Override
    public void release() {
        this.queues.release();
    }
}

