/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.beta.pregel.Messages;
import org.neo4j.gds.beta.pregel.Messenger;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.Reducer;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;

public class ReducingMessenger
implements Messenger<SingleMessageIterator> {
    private final Graph graph;
    private final PregelConfig config;
    private final Reducer reducer;
    private HugeAtomicDoubleArray sendArray;
    private HugeAtomicDoubleArray receiveArray;

    ReducingMessenger(Graph graph, PregelConfig config, Reducer reducer) {
        assert (!Double.isNaN(reducer.identity())) : "identity element must not be NaN";
        this.graph = graph;
        this.config = config;
        this.reducer = reducer;
        this.receiveArray = HugeAtomicDoubleArray.newArray((long)graph.nodeCount());
        this.sendArray = HugeAtomicDoubleArray.newArray((long)graph.nodeCount());
    }

    static MemoryEstimation memoryEstimation() {
        return MemoryEstimations.builder(ReducingMessenger.class).perNode("send array", HugeAtomicDoubleArray::memoryEstimation).perNode("receive array", HugeAtomicDoubleArray::memoryEstimation).build();
    }

    @Override
    public void initIteration(int iteration) {
        HugeAtomicDoubleArray tmp = this.receiveArray;
        this.receiveArray = this.sendArray;
        this.sendArray = tmp;
        ParallelUtil.parallelForEachNode((Graph)this.graph, (int)this.config.concurrency(), nodeId -> this.sendArray.set(nodeId, this.reducer.identity()));
    }

    @Override
    public void sendTo(long targetNodeId, double message) {
        this.sendArray.update(targetNodeId, current -> this.reducer.reduce(current, message));
    }

    @Override
    public SingleMessageIterator messageIterator() {
        return new SingleMessageIterator();
    }

    @Override
    public void initMessageIterator(SingleMessageIterator messageIterator, long nodeId, boolean isInitialIteration) {
        double message;
        messageIterator.init(message, (message = this.receiveArray.getAndReplace(nodeId, this.reducer.identity())) != this.reducer.identity());
    }

    @Override
    public void release() {
        this.sendArray.release();
        this.receiveArray.release();
    }

    static class SingleMessageIterator
    implements Messages.MessageIterator {
        boolean hasNext;
        double message;

        SingleMessageIterator() {
        }

        void init(double value, boolean hasNext) {
            this.message = value;
            this.hasNext = hasNext;
        }

        @Override
        public boolean isEmpty() {
            return !this.hasNext;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public double nextDouble() {
            this.hasNext = false;
            return this.message;
        }
    }
}

