/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;

public abstract class PrimitiveDoubleQueues {
    private static final VarHandle ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(double[].class);
    static final int MIN_CAPACITY = 42;
    private final HugeAtomicLongArray referenceCounts;
    HugeObjectArray<double[]> queues;
    HugeAtomicLongArray tails;

    PrimitiveDoubleQueues(HugeObjectArray<double[]> queues, HugeAtomicLongArray tails, HugeAtomicLongArray referenceCounts) {
        this.tails = tails;
        this.queues = queues;
        this.referenceCounts = referenceCounts;
    }

    abstract void grow(long var1, int var3);

    public void push(long nodeId, double message) {
        long idx;
        block4: {
            long nextIdx;
            while (true) {
                long currentIdx;
                if ((idx = this.tails.get(nodeId)) < 0L) {
                    long nextId = -idx + 1L;
                    do {
                        if ((currentIdx = this.tails.compareAndExchange(nodeId, -idx, nextId)) != -idx) continue;
                        idx = -idx;
                        break block4;
                    } while (currentIdx == idx);
                    continue;
                }
                nextIdx = idx + 1L;
                if (this.hasSpaceLeft(nodeId, (int)nextIdx)) {
                    currentIdx = this.tails.compareAndExchange(nodeId, idx, nextIdx);
                    if (currentIdx != idx) continue;
                    break block4;
                }
                currentIdx = this.tails.compareAndExchange(nodeId, idx, -nextIdx);
                if (currentIdx == idx) break;
            }
            this.getExclusiveReference(nodeId);
            this.grow(nodeId, (int)nextIdx);
            this.dropExclusiveReference(nodeId);
            this.tails.compareAndExchange(nodeId, -nextIdx, nextIdx);
        }
        VarHandle.fullFence();
        this.getSharedReference(nodeId);
        ARRAY_HANDLE.setVolatile((double[])this.queues.get(nodeId), (int)idx, message);
        this.dropSharedReference(nodeId);
    }

    private void getSharedReference(long nodeId) {
        long refCount;
        while ((refCount = this.referenceCounts.get(nodeId)) < 0L || !this.referenceCounts.compareAndSet(nodeId, refCount, refCount + 1L)) {
        }
    }

    private void dropSharedReference(long nodeId) {
        this.referenceCounts.getAndAdd(nodeId, -1L);
    }

    private void getExclusiveReference(long nodeId) {
        long refCount;
        while ((refCount = this.referenceCounts.get(nodeId)) > 0L || !this.referenceCounts.compareAndSet(nodeId, refCount, -1L)) {
        }
    }

    private void dropExclusiveReference(long nodeId) {
        this.referenceCounts.set(nodeId, 0L);
    }

    private boolean hasSpaceLeft(long nodeId, int minCapacity) {
        return ((double[])this.queues.get(nodeId)).length >= minCapacity;
    }

    void release() {
        this.queues.release();
        this.tails.release();
        this.referenceCounts.release();
    }

    @TestOnly
    long tail(long nodeId) {
        return this.tails.get(nodeId);
    }

    @TestOnly
    double[] queue(long nodeId) {
        return (double[])this.queues.get(nodeId);
    }
}

