/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.Arrays;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.beta.pregel.Messages;
import org.neo4j.gds.beta.pregel.PrimitiveDoubleQueues;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.mem.MemoryUsage;

public final class PrimitiveAsyncDoubleQueues
extends PrimitiveDoubleQueues {
    public static final double COMPACT_THRESHOLD = 0.25;
    private static final double EMPTY_MESSAGE = Double.NaN;
    private final HugeIntArray heads;
    private final HugeCursor<double[][]> queuesCursor;

    public static PrimitiveAsyncDoubleQueues of(long nodeCount) {
        return PrimitiveAsyncDoubleQueues.of(nodeCount, 42);
    }

    public static PrimitiveAsyncDoubleQueues of(long nodeCount, int initialQueueCapacity) {
        HugeIntArray heads = HugeIntArray.newArray((long)nodeCount);
        HugeAtomicLongArray tails = HugeAtomicLongArray.newArray((long)nodeCount);
        HugeObjectArray queues = HugeObjectArray.newArray(double[].class, (long)nodeCount);
        HugeAtomicLongArray referenceCounts = HugeAtomicLongArray.newArray((long)nodeCount);
        int capacity = Math.max(initialQueueCapacity, 42);
        queues.setAll(value -> {
            double[] queue = new double[capacity];
            Arrays.fill(queue, Double.NaN);
            return queue;
        });
        return new PrimitiveAsyncDoubleQueues(heads, tails, (HugeObjectArray<double[]>)queues, referenceCounts);
    }

    public static MemoryEstimation memoryEstimation() {
        return MemoryEstimations.builder(PrimitiveAsyncDoubleQueues.class).add("queues", HugeObjectArray.memoryEstimation((long)MemoryUsage.sizeOfDoubleArray((long)42L))).perNode("heads", HugeIntArray::memoryEstimation).perNode("tails", HugeAtomicLongArray::memoryEstimation).perNode("reference counts", HugeAtomicLongArray::memoryEstimation).build();
    }

    private PrimitiveAsyncDoubleQueues(HugeIntArray heads, HugeAtomicLongArray tails, HugeObjectArray<double[]> queues, HugeAtomicLongArray referenceCounts) {
        super(queues, tails, referenceCounts);
        this.heads = heads;
        this.queuesCursor = queues.newCursor();
    }

    public void compact() {
        this.queues.initCursor(this.queuesCursor);
        while (this.queuesCursor.next()) {
            for (int i = this.queuesCursor.offset; i < this.queuesCursor.limit; ++i) {
                double[] queue = ((double[][])this.queuesCursor.array)[i];
                int tail = (int)this.tails.get((long)i);
                int head = this.heads.get((long)i);
                if (this.isEmpty(queue, head, tail) && head > 0) {
                    Arrays.fill(queue, 0, tail, Double.NaN);
                    this.heads.set((long)i, 0);
                    this.tails.set((long)i, 0L);
                    continue;
                }
                if (!((double)head > (double)queue.length * 0.25)) continue;
                int length = tail - head;
                System.arraycopy(queue, head, queue, 0, length);
                Arrays.fill(queue, length, queue.length, Double.NaN);
                this.heads.set((long)i, 0);
                this.tails.set((long)i, (long)length);
            }
        }
    }

    boolean isEmpty(long nodeId) {
        int head = this.heads.get(nodeId);
        int tail = (int)this.tails.get(nodeId);
        double[] queue = (double[])this.queues.get(nodeId);
        return this.isEmpty(queue, head, tail);
    }

    private boolean isEmpty(double[] queue, int head, int tail) {
        return head == queue.length || head > tail || Double.isNaN(queue[head]);
    }

    double pop(long nodeId) {
        int currentHead = this.heads.getAndAdd(nodeId, 1);
        return ((double[])this.queues.get(nodeId))[currentHead];
    }

    @Override
    void grow(long nodeId, int minCapacity) {
        double[] queue = (double[])this.queues.get(nodeId);
        int capacity = queue.length;
        int newCapacity = capacity + (capacity >> 1);
        double[] resizedArray = Arrays.copyOf(queue, newCapacity);
        Arrays.fill(resizedArray, minCapacity - 1, newCapacity, Double.NaN);
        this.queues.set(nodeId, (Object)resizedArray);
    }

    @Override
    void release() {
        super.release();
        this.heads.release();
    }

    @TestOnly
    long head(long nodeId) {
        return this.heads.get(nodeId);
    }

    public static class Iterator
    implements Messages.MessageIterator {
        private final PrimitiveAsyncDoubleQueues queues;
        private long nodeId;

        public Iterator(PrimitiveAsyncDoubleQueues queues) {
            this.queues = queues;
        }

        void init(long nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public boolean hasNext() {
            return !this.queues.isEmpty(this.nodeId);
        }

        @Override
        public double nextDouble() {
            return this.queues.pop(this.nodeId);
        }

        @Override
        public boolean isEmpty() {
            return this.queues.isEmpty(this.nodeId);
        }
    }
}

