/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.beta.pregel.Partitioning;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;

@ValueClass
@Configuration
public interface PregelConfig
extends AlgoBaseConfig,
RelationshipWeightConfig,
IterationsConfig,
ConcurrencyConfig {
    @Value.Default
    @Configuration.Key(value="isAsynchronous")
    default public boolean isAsynchronous() {
        return false;
    }

    @Value.Default
    @Configuration.ConvertWith(method="org.neo4j.gds.beta.pregel.Partitioning#parse")
    @Configuration.ToMapValue(value="org.neo4j.gds.beta.pregel.Partitioning#toString")
    default public Partitioning partitioning() {
        return Partitioning.RANGE;
    }

    @Value.Derived
    @Configuration.Ignore
    default public boolean useForkJoin() {
        return this.partitioning() == Partitioning.AUTO;
    }
}

