/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.beta.pregel.Messenger;
import org.neo4j.gds.beta.pregel.NodeValue;
import org.neo4j.gds.beta.pregel.PartitionedComputeStep;
import org.neo4j.gds.beta.pregel.PregelComputation;
import org.neo4j.gds.beta.pregel.PregelComputer;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.utils.StringFormatting;

public class PartitionedComputer<CONFIG extends PregelConfig>
extends PregelComputer<CONFIG> {
    private final ExecutorService executorService;
    private final int concurrency;
    private List<PartitionedComputeStep<CONFIG, ?>> computeSteps;

    PartitionedComputer(Graph graph, PregelComputation<CONFIG> computation, CONFIG config, NodeValue nodeValues, Messenger<?> messenger, HugeAtomicBitSet voteBits, int concurrency, ExecutorService executorService, ProgressTracker progressTracker) {
        super(graph, computation, config, nodeValues, messenger, voteBits, progressTracker);
        this.executorService = executorService;
        this.concurrency = concurrency;
    }

    @Override
    public void initComputation() {
        this.computeSteps = this.createComputeSteps(this.voteBits);
    }

    @Override
    public void initIteration(int iteration) {
        for (PartitionedComputeStep<CONFIG, ?> computeStep : this.computeSteps) {
            computeStep.init(iteration);
        }
    }

    @Override
    public void runIteration() {
        RunWithConcurrency.builder().concurrency(this.concurrency).tasks(this.computeSteps).executor(this.executorService).run();
    }

    @Override
    public boolean hasConverged() {
        boolean lastIterationSendMessages = this.computeSteps.stream().anyMatch(PartitionedComputeStep::hasSentMessage);
        return !lastIterationSendMessages && this.voteBits.allSet();
    }

    @Override
    void release() {
        this.computation.close();
    }

    @NotNull
    private List<PartitionedComputeStep<CONFIG, ?>> createComputeSteps(HugeAtomicBitSet voteBits) {
        Function<Partition, PartitionedComputeStep> partitionFunction = partition -> new PartitionedComputeStep(this.graph.concurrentCopy(), this.computation, this.config, 0, (Partition)partition, this.nodeValues, this.messenger, voteBits, this.progressTracker);
        switch (this.config.partitioning()) {
            case RANGE: {
                return PartitionUtils.rangePartition((int)this.concurrency, (long)this.graph.nodeCount(), partitionFunction, Optional.empty());
            }
            case DEGREE: {
                return PartitionUtils.degreePartition((Graph)this.graph, (int)this.concurrency, partitionFunction::apply, Optional.empty());
            }
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unsupported partitioning `%s`", (Object[])new Object[]{this.config.partitioning()}));
    }
}

