/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyContainer;
import org.neo4j.gds.beta.pregel.ComputeStep;
import org.neo4j.gds.beta.pregel.Messages;
import org.neo4j.gds.beta.pregel.Messenger;
import org.neo4j.gds.beta.pregel.NodeValue;
import org.neo4j.gds.beta.pregel.PregelComputation;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.context.ComputeContext;
import org.neo4j.gds.beta.pregel.context.InitContext;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public final class PartitionedComputeStep<CONFIG extends PregelConfig, ITERATOR extends Messages.MessageIterator>
implements Runnable,
ComputeStep<CONFIG, ITERATOR> {
    private final InitContext<CONFIG> initContext;
    private final ComputeContext<CONFIG> computeContext;
    private final ProgressTracker progressTracker;
    private final Partition nodeBatch;
    private final HugeAtomicBitSet voteBits;
    private final Messenger<ITERATOR> messenger;
    private final PregelComputation<CONFIG> computation;
    private final Graph graph;
    private int iteration;
    private final NodeValue nodeValue;
    private boolean hasSentMessage;

    PartitionedComputeStep(Graph graph, PregelComputation<CONFIG> computation, CONFIG config, int iteration, Partition nodeBatch, NodeValue nodeValue, Messenger<ITERATOR> messenger, HugeAtomicBitSet voteBits, ProgressTracker progressTracker) {
        this.graph = graph;
        this.iteration = iteration;
        this.nodeValue = nodeValue;
        this.computation = computation;
        this.voteBits = voteBits;
        this.nodeBatch = nodeBatch;
        this.messenger = messenger;
        this.computeContext = new ComputeContext<CONFIG>(this, config, progressTracker);
        this.progressTracker = progressTracker;
        this.initContext = new InitContext<CONFIG>(this, config, (NodePropertyContainer)graph, progressTracker);
    }

    @Override
    public void run() {
        this.computeBatch();
    }

    @Override
    public Graph graph() {
        return this.graph;
    }

    @Override
    public HugeAtomicBitSet voteBits() {
        return this.voteBits;
    }

    @Override
    public PregelComputation<CONFIG> computation() {
        return this.computation;
    }

    @Override
    public NodeValue nodeValue() {
        return this.nodeValue;
    }

    @Override
    public Messenger<ITERATOR> messenger() {
        return this.messenger;
    }

    @Override
    public Partition nodeBatch() {
        return this.nodeBatch;
    }

    @Override
    public InitContext<CONFIG> initContext() {
        return this.initContext;
    }

    @Override
    public ComputeContext<CONFIG> computeContext() {
        return this.computeContext;
    }

    @Override
    public ProgressTracker progressTracker() {
        return this.progressTracker;
    }

    @Override
    public int iteration() {
        return this.iteration;
    }

    @Override
    public void sendTo(long targetNodeId, double message) {
        this.messenger.sendTo(targetNodeId, message);
        this.hasSentMessage = true;
    }

    void init(int iteration) {
        this.iteration = iteration;
        this.hasSentMessage = false;
    }

    boolean hasSentMessage() {
        return this.hasSentMessage;
    }
}

