/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.beta.pregel.NodeValue;
import org.neo4j.gds.beta.pregel.PregelResult;

@Generated(from="PregelResult", generator="Immutables")
public final class ImmutablePregelResult
implements PregelResult {
    private final NodeValue nodeValues;
    private final int ranIterations;
    private final boolean didConverge;

    private ImmutablePregelResult(NodeValue nodeValues, int ranIterations, boolean didConverge) {
        this.nodeValues = Objects.requireNonNull(nodeValues, "nodeValues");
        this.ranIterations = ranIterations;
        this.didConverge = didConverge;
    }

    private ImmutablePregelResult(ImmutablePregelResult original, NodeValue nodeValues, int ranIterations, boolean didConverge) {
        this.nodeValues = nodeValues;
        this.ranIterations = ranIterations;
        this.didConverge = didConverge;
    }

    @Override
    public NodeValue nodeValues() {
        return this.nodeValues;
    }

    @Override
    public int ranIterations() {
        return this.ranIterations;
    }

    @Override
    public boolean didConverge() {
        return this.didConverge;
    }

    public final ImmutablePregelResult withNodeValues(NodeValue value) {
        if (this.nodeValues == value) {
            return this;
        }
        NodeValue newValue = Objects.requireNonNull(value, "nodeValues");
        return new ImmutablePregelResult(this, newValue, this.ranIterations, this.didConverge);
    }

    public final ImmutablePregelResult withRanIterations(int value) {
        if (this.ranIterations == value) {
            return this;
        }
        return new ImmutablePregelResult(this, this.nodeValues, value, this.didConverge);
    }

    public final ImmutablePregelResult withDidConverge(boolean value) {
        if (this.didConverge == value) {
            return this;
        }
        return new ImmutablePregelResult(this, this.nodeValues, this.ranIterations, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePregelResult && this.equalTo((ImmutablePregelResult)another);
    }

    private boolean equalTo(ImmutablePregelResult another) {
        return this.nodeValues.equals(another.nodeValues) && this.ranIterations == another.ranIterations && this.didConverge == another.didConverge;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nodeValues.hashCode();
        h += (h << 5) + this.ranIterations;
        h += (h << 5) + Boolean.hashCode(this.didConverge);
        return h;
    }

    public String toString() {
        return "PregelResult{nodeValues=" + this.nodeValues + ", ranIterations=" + this.ranIterations + ", didConverge=" + this.didConverge + "}";
    }

    public static PregelResult of(NodeValue nodeValues, int ranIterations, boolean didConverge) {
        return new ImmutablePregelResult(nodeValues, ranIterations, didConverge);
    }

    public static PregelResult copyOf(PregelResult instance) {
        if (instance instanceof ImmutablePregelResult) {
            return (ImmutablePregelResult)instance;
        }
        return ImmutablePregelResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PregelResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NODE_VALUES = 1L;
        private static final long INIT_BIT_RAN_ITERATIONS = 2L;
        private static final long INIT_BIT_DID_CONVERGE = 4L;
        private long initBits = 7L;
        private NodeValue nodeValues;
        private int ranIterations;
        private boolean didConverge;

        private Builder() {
        }

        public final Builder from(PregelResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.nodeValues(instance.nodeValues());
            this.ranIterations(instance.ranIterations());
            this.didConverge(instance.didConverge());
            return this;
        }

        public final Builder nodeValues(NodeValue nodeValues) {
            this.nodeValues = Objects.requireNonNull(nodeValues, "nodeValues");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ranIterations(int ranIterations) {
            this.ranIterations = ranIterations;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder didConverge(boolean didConverge) {
            this.didConverge = didConverge;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.nodeValues = null;
            this.ranIterations = 0;
            this.didConverge = false;
            return this;
        }

        public PregelResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePregelResult(null, this.nodeValues, this.ranIterations, this.didConverge);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nodeValues");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ranIterations");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("didConverge");
            }
            return "Cannot build PregelResult, some of required attributes are not set " + attributes;
        }
    }
}

