/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.beta.pregel.Partitioning;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelProcedureConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.MutatePropertyConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.utils.progress.JobId;

@Generated(from="PregelProcedureConfig", generator="Immutables")
public final class ImmutablePregelProcedureConfig
implements PregelProcedureConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final int maxIterations;
    private final boolean isAsynchronous;
    private final Partitioning partitioning;
    private final transient boolean useForkJoin;
    private final int writeConcurrency;
    private final String writeProperty;
    private final String mutateProperty;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePregelProcedureConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<String> relationshipWeightProperty, int maxIterations, boolean isAsynchronous, Partitioning partitioning, int writeConcurrency, String writeProperty, String mutateProperty) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutablePregelProcedureConfig.createUnmodifiableList(false, ImmutablePregelProcedureConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutablePregelProcedureConfig.createUnmodifiableList(false, ImmutablePregelProcedureConfig.createSafeList(nodeLabels, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
        this.maxIterations = maxIterations;
        this.initShim.isAsynchronous(isAsynchronous);
        this.initShim.partitioning(Objects.requireNonNull(partitioning, "partitioning"));
        this.initShim.writeConcurrency(writeConcurrency);
        this.initShim.writeProperty(Objects.requireNonNull(writeProperty, "writeProperty"));
        this.initShim.mutateProperty(Objects.requireNonNull(mutateProperty, "mutateProperty"));
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.partitioning = this.initShim.partitioning();
        this.useForkJoin = this.initShim.useForkJoin();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.writeProperty = this.initShim.writeProperty();
        this.mutateProperty = this.initShim.mutateProperty();
        this.initShim = null;
    }

    private ImmutablePregelProcedureConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String relationshipWeightProperty, int maxIterations, boolean isAsynchronous, Partitioning partitioning, int writeConcurrency, String writeProperty, String mutateProperty) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutablePregelProcedureConfig.createUnmodifiableList(false, ImmutablePregelProcedureConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutablePregelProcedureConfig.createUnmodifiableList(false, ImmutablePregelProcedureConfig.createSafeList(nodeLabels, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.maxIterations = maxIterations;
        this.initShim.isAsynchronous(isAsynchronous);
        this.initShim.partitioning(Objects.requireNonNull(partitioning, "partitioning"));
        this.initShim.writeConcurrency(writeConcurrency);
        this.initShim.writeProperty(Objects.requireNonNull(writeProperty, "writeProperty"));
        this.initShim.mutateProperty(Objects.requireNonNull(mutateProperty, "mutateProperty"));
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.partitioning = this.initShim.partitioning();
        this.useForkJoin = this.initShim.useForkJoin();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.writeProperty = this.initShim.writeProperty();
        this.mutateProperty = this.initShim.mutateProperty();
        this.initShim = null;
    }

    private ImmutablePregelProcedureConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.relationshipWeightProperty = builder.relationshipWeightProperty;
        this.maxIterations = builder.maxIterations;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutablePregelProcedureConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutablePregelProcedureConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.isAsynchronousIsSet()) {
            this.initShim.isAsynchronous(builder.isAsynchronous);
        }
        if (builder.partitioning != null) {
            this.initShim.partitioning(builder.partitioning);
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        if (builder.writeProperty != null) {
            this.initShim.writeProperty(builder.writeProperty);
        }
        if (builder.mutateProperty != null) {
            this.initShim.mutateProperty(builder.mutateProperty);
        }
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.partitioning = this.initShim.partitioning();
        this.useForkJoin = this.initShim.useForkJoin();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.writeProperty = this.initShim.writeProperty();
        this.mutateProperty = this.initShim.mutateProperty();
        this.initShim = null;
    }

    private ImmutablePregelProcedureConfig(String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, String relationshipWeightProperty, int maxIterations, boolean isAsynchronous, Partitioning partitioning, int writeConcurrency, String writeProperty, String mutateProperty) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.maxIterations = maxIterations;
        this.initShim.isAsynchronous(isAsynchronous);
        this.initShim.partitioning(partitioning);
        this.initShim.writeConcurrency(writeConcurrency);
        this.initShim.writeProperty(writeProperty);
        this.initShim.mutateProperty(mutateProperty);
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.partitioning = this.initShim.partitioning();
        this.useForkJoin = this.initShim.useForkJoin();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.writeProperty = this.initShim.writeProperty();
        this.mutateProperty = this.initShim.mutateProperty();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return PregelProcedureConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return PregelProcedureConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return PregelProcedureConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return PregelProcedureConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return PregelProcedureConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return PregelProcedureConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return PregelProcedureConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return PregelProcedureConfig.super.nodeLabels();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return PregelProcedureConfig.super.hasRelationshipWeightProperty();
    }

    private boolean isAsynchronousInitialize() {
        return PregelProcedureConfig.super.isAsynchronous();
    }

    private Partitioning partitioningInitialize() {
        return PregelProcedureConfig.super.partitioning();
    }

    private boolean useForkJoinInitialize() {
        return PregelProcedureConfig.super.useForkJoin();
    }

    private int writeConcurrencyInitialize() {
        return PregelProcedureConfig.super.writeConcurrency();
    }

    private String writePropertyInitialize() {
        return PregelProcedureConfig.super.writeProperty();
    }

    private String mutatePropertyInitialize() {
        return PregelProcedureConfig.super.mutateProperty();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<String> relationshipWeightProperty() {
        return Optional.ofNullable(this.relationshipWeightProperty);
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    public int maxIterations() {
        return this.maxIterations;
    }

    @Override
    public boolean isAsynchronous() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAsynchronous() : this.isAsynchronous;
    }

    @Override
    public Partitioning partitioning() {
        InitShim shim = this.initShim;
        return shim != null ? shim.partitioning() : this.partitioning;
    }

    @Override
    public boolean useForkJoin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useForkJoin() : this.useForkJoin;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    @Override
    public String writeProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeProperty() : this.writeProperty;
    }

    @Override
    public String mutateProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mutateProperty() : this.mutateProperty;
    }

    public final ImmutablePregelProcedureConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(newValue, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutablePregelProcedureConfig.createUnmodifiableList(false, ImmutablePregelProcedureConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutablePregelProcedureConfig.createUnmodifiableList(false, ImmutablePregelProcedureConfig.createSafeList(elements, true, false));
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutablePregelProcedureConfig.createUnmodifiableList(false, ImmutablePregelProcedureConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutablePregelProcedureConfig.createUnmodifiableList(false, ImmutablePregelProcedureConfig.createSafeList(elements, true, false));
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withRelationshipWeightProperty(String value) {
        String newValue = value;
        if (Objects.equals(this.relationshipWeightProperty, newValue)) {
            return this;
        }
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, newValue, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withRelationshipWeightProperty(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, value, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withIsAsynchronous(boolean value) {
        if (this.isAsynchronous == value) {
            return this;
        }
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, value, this.partitioning, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withPartitioning(Partitioning value) {
        if (this.partitioning == value) {
            return this;
        }
        Partitioning newValue = Objects.requireNonNull(value, "partitioning");
        if (this.partitioning.equals((Object)newValue)) {
            return this;
        }
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, newValue, this.writeConcurrency, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, this.partitioning, value, this.writeProperty, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withWriteProperty(String value) {
        String newValue = Objects.requireNonNull(value, "writeProperty");
        if (this.writeProperty.equals(newValue)) {
            return this;
        }
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, newValue, this.mutateProperty));
    }

    public final ImmutablePregelProcedureConfig withMutateProperty(String value) {
        String newValue = Objects.requireNonNull(value, "mutateProperty");
        if (this.mutateProperty.equals(newValue)) {
            return this;
        }
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.maxIterations, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePregelProcedureConfig && this.equalTo((ImmutablePregelProcedureConfig)another);
    }

    private boolean equalTo(ImmutablePregelProcedureConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && this.maxIterations == another.maxIterations && this.isAsynchronous == another.isAsynchronous && this.partitioning.equals((Object)another.partitioning) && this.useForkJoin == another.useForkJoin && this.writeConcurrency == another.writeConcurrency && this.writeProperty.equals(another.writeProperty) && this.mutateProperty.equals(another.mutateProperty);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + Boolean.hashCode(this.isAsynchronous);
        h += (h << 5) + this.partitioning.hashCode();
        h += (h << 5) + Boolean.hashCode(this.useForkJoin);
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + this.writeProperty.hashCode();
        h += (h << 5) + this.mutateProperty.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PregelProcedureConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 22) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        builder.append(", ");
        builder.append("maxIterations=").append(this.maxIterations);
        builder.append(", ");
        builder.append("isAsynchronous=").append(this.isAsynchronous);
        builder.append(", ");
        builder.append("partitioning=").append((Object)this.partitioning);
        builder.append(", ");
        builder.append("useForkJoin=").append(this.useForkJoin);
        builder.append(", ");
        builder.append("writeConcurrency=").append(this.writeConcurrency);
        builder.append(", ");
        builder.append("writeProperty=").append(this.writeProperty);
        builder.append(", ");
        builder.append("mutateProperty=").append(this.mutateProperty);
        return builder.append("}").toString();
    }

    public static PregelProcedureConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, Optional<String> relationshipWeightProperty, int maxIterations, boolean isAsynchronous, Partitioning partitioning, int writeConcurrency, String writeProperty, String mutateProperty) {
        return ImmutablePregelProcedureConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, maxIterations, isAsynchronous, partitioning, writeConcurrency, writeProperty, mutateProperty);
    }

    public static PregelProcedureConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<String> relationshipWeightProperty, int maxIterations, boolean isAsynchronous, Partitioning partitioning, int writeConcurrency, String writeProperty, String mutateProperty) {
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, maxIterations, isAsynchronous, partitioning, writeConcurrency, writeProperty, mutateProperty));
    }

    public static PregelProcedureConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String relationshipWeightProperty, int maxIterations, boolean isAsynchronous, Partitioning partitioning, int writeConcurrency, String writeProperty, String mutateProperty) {
        return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, maxIterations, isAsynchronous, partitioning, writeConcurrency, writeProperty, mutateProperty));
    }

    private static ImmutablePregelProcedureConfig validate(ImmutablePregelProcedureConfig instance) {
        instance.validateWriteConcurrency();
        instance.validateRelationshipWeightProperty();
        instance.validateConcurrency();
        return instance;
    }

    public static PregelProcedureConfig copyOf(PregelProcedureConfig instance) {
        if (instance instanceof ImmutablePregelProcedureConfig) {
            return (ImmutablePregelProcedureConfig)instance;
        }
        return ImmutablePregelProcedureConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PregelProcedureConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MAX_ITERATIONS = 1L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_CONCURRENCY = 2L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 4L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 8L;
        private static final long OPT_BIT_NODE_LABELS = 16L;
        private static final long OPT_BIT_IS_ASYNCHRONOUS = 32L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 64L;
        private long initBits = 1L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String relationshipWeightProperty;
        private int maxIterations;
        private boolean isAsynchronous;
        private Partitioning partitioning;
        private int writeConcurrency;
        private String writeProperty;
        private String mutateProperty;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WritePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PregelProcedureConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MutatePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PregelConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RelationshipWeightConfig instance;
            Optional relationshipWeightPropertyOptional;
            long bits = 0L;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyOptional = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()).isPresent()) {
                this.relationshipWeightProperty(relationshipWeightPropertyOptional);
            }
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                this.writeConcurrency(instance.writeConcurrency());
            }
            if (object instanceof WritePropertyConfig) {
                instance = (WritePropertyConfig)object;
                if ((bits & 1L) == 0L) {
                    this.writeProperty(instance.writeProperty());
                    bits |= 1L;
                }
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof PregelProcedureConfig) {
                instance = (PregelProcedureConfig)object;
                if ((bits & 1L) == 0L) {
                    this.writeProperty(instance.writeProperty());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.mutateProperty(instance.mutateProperty());
                    bits |= 2L;
                }
            }
            if (object instanceof MutatePropertyConfig) {
                instance = (MutatePropertyConfig)object;
                if ((bits & 2L) == 0L) {
                    this.mutateProperty(instance.mutateProperty());
                    bits |= 2L;
                }
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof PregelConfig) {
                instance = (PregelConfig)object;
                this.partitioning(instance.partitioning());
                this.isAsynchronous(instance.isAsynchronous());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                this.maxIterations(instance.maxIterations());
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 2L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 4L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            return this;
        }

        public final Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder isAsynchronous(boolean isAsynchronous) {
            this.isAsynchronous = isAsynchronous;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder partitioning(Partitioning partitioning) {
            this.partitioning = Objects.requireNonNull(partitioning, "partitioning");
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder writeProperty(String writeProperty) {
            this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
            return this;
        }

        public final Builder mutateProperty(String mutateProperty) {
            this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.relationshipWeightProperty = null;
            this.maxIterations = 0;
            this.isAsynchronous = false;
            this.partitioning = null;
            this.writeConcurrency = 0;
            this.writeProperty = null;
            this.mutateProperty = null;
            return this;
        }

        public PregelProcedureConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutablePregelProcedureConfig.validate(new ImmutablePregelProcedureConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean isAsynchronousIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("maxIterations");
            }
            return "Cannot build PregelProcedureConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="PregelProcedureConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte isAsynchronousBuildStage = 0;
        private boolean isAsynchronous;
        private byte partitioningBuildStage = 0;
        private Partitioning partitioning;
        private byte useForkJoinBuildStage = 0;
        private boolean useForkJoin;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;
        private byte writePropertyBuildStage = 0;
        private String writeProperty;
        private byte mutatePropertyBuildStage = 0;
        private String mutateProperty;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutablePregelProcedureConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutablePregelProcedureConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutablePregelProcedureConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutablePregelProcedureConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutablePregelProcedureConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutablePregelProcedureConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutablePregelProcedureConfig.createUnmodifiableList(false, ImmutablePregelProcedureConfig.createSafeList(ImmutablePregelProcedureConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutablePregelProcedureConfig.createUnmodifiableList(false, ImmutablePregelProcedureConfig.createSafeList(ImmutablePregelProcedureConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutablePregelProcedureConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        boolean isAsynchronous() {
            if (this.isAsynchronousBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isAsynchronousBuildStage == 0) {
                this.isAsynchronousBuildStage = (byte)-1;
                this.isAsynchronous = ImmutablePregelProcedureConfig.this.isAsynchronousInitialize();
                this.isAsynchronousBuildStage = 1;
            }
            return this.isAsynchronous;
        }

        void isAsynchronous(boolean isAsynchronous) {
            this.isAsynchronous = isAsynchronous;
            this.isAsynchronousBuildStage = 1;
        }

        Partitioning partitioning() {
            if (this.partitioningBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.partitioningBuildStage == 0) {
                this.partitioningBuildStage = (byte)-1;
                this.partitioning = Objects.requireNonNull(ImmutablePregelProcedureConfig.this.partitioningInitialize(), "partitioning");
                this.partitioningBuildStage = 1;
            }
            return this.partitioning;
        }

        void partitioning(Partitioning partitioning) {
            this.partitioning = partitioning;
            this.partitioningBuildStage = 1;
        }

        boolean useForkJoin() {
            if (this.useForkJoinBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useForkJoinBuildStage == 0) {
                this.useForkJoinBuildStage = (byte)-1;
                this.useForkJoin = ImmutablePregelProcedureConfig.this.useForkJoinInitialize();
                this.useForkJoinBuildStage = 1;
            }
            return this.useForkJoin;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutablePregelProcedureConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        String writeProperty() {
            if (this.writePropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writePropertyBuildStage == 0) {
                this.writePropertyBuildStage = (byte)-1;
                this.writeProperty = Objects.requireNonNull(ImmutablePregelProcedureConfig.this.writePropertyInitialize(), "writeProperty");
                this.writePropertyBuildStage = 1;
            }
            return this.writeProperty;
        }

        void writeProperty(String writeProperty) {
            this.writeProperty = writeProperty;
            this.writePropertyBuildStage = 1;
        }

        String mutateProperty() {
            if (this.mutatePropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mutatePropertyBuildStage == 0) {
                this.mutatePropertyBuildStage = (byte)-1;
                this.mutateProperty = Objects.requireNonNull(ImmutablePregelProcedureConfig.this.mutatePropertyInitialize(), "mutateProperty");
                this.mutatePropertyBuildStage = 1;
            }
            return this.mutateProperty;
        }

        void mutateProperty(String mutateProperty) {
            this.mutateProperty = mutateProperty;
            this.mutatePropertyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.isAsynchronousBuildStage == -1) {
                attributes.add("isAsynchronous");
            }
            if (this.partitioningBuildStage == -1) {
                attributes.add("partitioning");
            }
            if (this.useForkJoinBuildStage == -1) {
                attributes.add("useForkJoin");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            if (this.writePropertyBuildStage == -1) {
                attributes.add("writeProperty");
            }
            if (this.mutatePropertyBuildStage == -1) {
                attributes.add("mutateProperty");
            }
            return "Cannot build PregelProcedureConfig, attribute initializers form cycle " + attributes;
        }
    }
}

