/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.beta.pregel.ForkJoinComputeStep;
import org.neo4j.gds.beta.pregel.Messenger;
import org.neo4j.gds.beta.pregel.NodeValue;
import org.neo4j.gds.beta.pregel.PregelComputation;
import org.neo4j.gds.beta.pregel.PregelComputer;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public class ForkJoinComputer<CONFIG extends PregelConfig>
extends PregelComputer<CONFIG> {
    private final ForkJoinPool forkJoinPool;
    private AtomicBoolean sentMessage;
    private ForkJoinComputeStep<CONFIG, ?> rootTask;

    ForkJoinComputer(Graph graph, PregelComputation<CONFIG> computation, CONFIG config, NodeValue nodeValues, Messenger<?> messenger, HugeAtomicBitSet voteBits, ForkJoinPool forkJoinPool, ProgressTracker progressTracker) {
        super(graph, computation, config, nodeValues, messenger, voteBits, progressTracker);
        this.forkJoinPool = forkJoinPool;
    }

    @Override
    public void initComputation() {
    }

    @Override
    public void initIteration(int iteration) {
        this.sentMessage = new AtomicBoolean(false);
        this.rootTask = new ForkJoinComputeStep(this.graph, this.computation, this.config, iteration, Partition.of((long)0L, (long)this.graph.nodeCount()), this.nodeValues, this.messenger, this.voteBits, null, this.sentMessage, this.progressTracker);
    }

    @Override
    public void runIteration() {
        this.forkJoinPool.invoke(this.rootTask);
    }

    @Override
    public boolean hasConverged() {
        return !this.sentMessage.get() && this.voteBits.allSet();
    }

    @Override
    void release() {
        this.forkJoinPool.shutdown();
        this.computation.close();
    }
}

