/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.concurrent.CountedCompleter;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyContainer;
import org.neo4j.gds.beta.pregel.ComputeStep;
import org.neo4j.gds.beta.pregel.Messages;
import org.neo4j.gds.beta.pregel.Messenger;
import org.neo4j.gds.beta.pregel.NodeValue;
import org.neo4j.gds.beta.pregel.PregelComputation;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.context.ComputeContext;
import org.neo4j.gds.beta.pregel.context.InitContext;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.mem.BitUtil;

public final class ForkJoinComputeStep<CONFIG extends PregelConfig, ITERATOR extends Messages.MessageIterator>
extends CountedCompleter<Void>
implements ComputeStep<CONFIG, ITERATOR> {
    private static final int SEQUENTIAL_THRESHOLD = 1000;
    private final Graph graph;
    private final CONFIG config;
    private final InitContext<CONFIG> initContext;
    private final ComputeContext<CONFIG> computeContext;
    private final NodeValue nodeValue;
    private final HugeAtomicBitSet voteBits;
    private final Messenger<ITERATOR> messenger;
    private final PregelComputation<CONFIG> computation;
    private Partition nodeBatch;
    private final int iteration;
    private boolean hasSendMessage;
    private final AtomicBoolean sentMessage;
    private final ProgressTracker progressTracker;

    ForkJoinComputeStep(Graph graph, PregelComputation<CONFIG> computation, CONFIG config, int iteration, Partition nodeBatch, NodeValue nodeValue, Messenger<ITERATOR> messenger, HugeAtomicBitSet voteBits, @Nullable CountedCompleter<Void> parent, AtomicBoolean sentMessage, ProgressTracker progressTracker) {
        super(parent);
        this.graph = graph;
        this.config = config;
        this.iteration = iteration;
        this.computation = computation;
        this.voteBits = voteBits;
        this.nodeBatch = nodeBatch;
        this.nodeValue = nodeValue;
        this.messenger = messenger;
        this.computeContext = new ComputeContext<CONFIG>(this, config, progressTracker);
        this.sentMessage = sentMessage;
        this.progressTracker = progressTracker;
        this.initContext = new InitContext<CONFIG>(this, config, (NodePropertyContainer)graph, progressTracker);
    }

    @Override
    public void compute() {
        if (this.nodeBatch.nodeCount() >= 1000L) {
            long startNode = this.nodeBatch.startNode();
            long batchSize = this.nodeBatch.nodeCount();
            boolean isEven = batchSize % 2L == 0L;
            long pivot = BitUtil.ceilDiv((long)batchSize, (long)2L);
            Partition rightBatch = isEven ? Partition.of((long)(startNode + pivot), (long)pivot) : Partition.of((long)(startNode + pivot), (long)(pivot - 1L));
            Partition leftBatch = Partition.of((long)startNode, (long)pivot);
            ForkJoinComputeStep<CONFIG, ITERATOR> leftTask = new ForkJoinComputeStep<CONFIG, ITERATOR>(this.graph.concurrentCopy(), this.computation, this.config, this.iteration, leftBatch, this.nodeValue, this.messenger, this.voteBits, this, this.sentMessage, this.progressTracker);
            this.nodeBatch = rightBatch;
            this.addToPendingCount(1);
            leftTask.fork();
            this.compute();
        } else {
            this.computeBatch();
            this.sentMessage.set(this.hasSendMessage);
            this.tryComplete();
        }
    }

    @Override
    public Graph graph() {
        return this.graph;
    }

    @Override
    public HugeAtomicBitSet voteBits() {
        return this.voteBits;
    }

    @Override
    public PregelComputation<CONFIG> computation() {
        return this.computation;
    }

    @Override
    public NodeValue nodeValue() {
        return this.nodeValue;
    }

    @Override
    public Messenger<ITERATOR> messenger() {
        return this.messenger;
    }

    @Override
    public Partition nodeBatch() {
        return this.nodeBatch;
    }

    @Override
    public InitContext<CONFIG> initContext() {
        return this.initContext;
    }

    @Override
    public ComputeContext<CONFIG> computeContext() {
        return this.computeContext;
    }

    @Override
    public ProgressTracker progressTracker() {
        return this.progressTracker;
    }

    @Override
    public int iteration() {
        return this.iteration;
    }

    @Override
    public void sendTo(long targetNodeId, double message) {
        this.messenger.sendTo(targetNodeId, message);
        this.hasSendMessage = true;
    }
}

