/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.function.LongConsumer;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.beta.pregel.Messages;
import org.neo4j.gds.beta.pregel.Messenger;
import org.neo4j.gds.beta.pregel.NodeValue;
import org.neo4j.gds.beta.pregel.PregelComputation;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.context.ComputeContext;
import org.neo4j.gds.beta.pregel.context.InitContext;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public interface ComputeStep<CONFIG extends PregelConfig, ITERATOR extends Messages.MessageIterator> {
    public Graph graph();

    public HugeAtomicBitSet voteBits();

    public PregelComputation<CONFIG> computation();

    public NodeValue nodeValue();

    public Messenger<ITERATOR> messenger();

    public Partition nodeBatch();

    public InitContext<CONFIG> initContext();

    public ComputeContext<CONFIG> computeContext();

    public ProgressTracker progressTracker();

    public int iteration();

    default public boolean isMultiGraph() {
        return this.graph().isMultiGraph();
    }

    default public long nodeCount() {
        return this.graph().nodeCount();
    }

    default public long relationshipCount() {
        return this.graph().relationshipCount();
    }

    default public int degree(long nodeId) {
        return this.graph().degree(nodeId);
    }

    default public long toOriginalNodeId(long internalNodeId) {
        return this.graph().toOriginalNodeId(internalNodeId);
    }

    default public long toInternalNodeId(long originalNodeId) {
        return this.graph().toMappedNodeId(originalNodeId);
    }

    default public void voteToHalt(long nodeId) {
        this.voteBits().set(nodeId);
    }

    public void sendTo(long var1, double var3);

    default public void computeBatch() {
        Messenger messenger = this.messenger();
        Object messageIterator = messenger.messageIterator();
        Messages messages = new Messages((Messages.MessageIterator)messageIterator);
        Partition nodeBatch = this.nodeBatch();
        PregelComputation computation = this.computation();
        InitContext initContext = this.initContext();
        ComputeContext computeContext = this.computeContext();
        HugeAtomicBitSet voteBits = this.voteBits();
        nodeBatch.consume(nodeId -> {
            if (computeContext.isInitialSuperstep()) {
                initContext.setNodeId(nodeId);
                computation.init(initContext);
            }
            messenger.initMessageIterator(messageIterator, nodeId, computeContext.isInitialSuperstep());
            if (!messages.isEmpty() || !voteBits.get(nodeId)) {
                voteBits.clear(nodeId);
                computeContext.setNodeId(nodeId);
                computation.compute(computeContext, messages);
            }
        });
        this.progressTracker().logProgress(nodeBatch.nodeCount());
    }

    default public void sendToNeighbors(long sourceNodeId, double message) {
        this.graph().forEachRelationship(sourceNodeId, (ignored, targetNodeId) -> {
            this.sendTo(targetNodeId, message);
            return true;
        });
    }

    default public void sendToNeighborsWeighted(long sourceNodeId, double message) {
        this.graph().forEachRelationship(sourceNodeId, 1.0, (ignored, targetNodeId, weight) -> {
            this.sendTo(targetNodeId, this.computation().applyRelationshipWeight(message, weight));
            return true;
        });
    }

    default public void forEachNeighbor(long sourceNodeId, LongConsumer targetConsumer) {
        this.graph().forEachRelationship(sourceNodeId, (ignored, targetNodeId) -> {
            targetConsumer.accept(targetNodeId);
            return true;
        });
    }

    default public void forEachDistinctNeighbor(long sourceNodeId, LongConsumer targetConsumer) {
        MutableLong prevTarget = new MutableLong(-1L);
        this.graph().forEachRelationship(sourceNodeId, (ignored, targetNodeId) -> {
            if (prevTarget.longValue() != targetNodeId) {
                targetConsumer.accept(targetNodeId);
                prevTarget.setValue(targetNodeId);
            }
            return true;
        });
    }

    default public double doubleNodeValue(String key, long nodeId) {
        return this.nodeValue().doubleValue(key, nodeId);
    }

    default public long longNodeValue(String key, long nodeId) {
        return this.nodeValue().longValue(key, nodeId);
    }

    default public long[] longArrayNodeValue(String key, long nodeId) {
        return this.nodeValue().longArrayValue(key, nodeId);
    }

    default public double[] doubleArrayNodeValue(String key, long nodeId) {
        return this.nodeValue().doubleArrayValue(key, nodeId);
    }

    default public void setNodeValue(String key, long nodeId, double value) {
        this.nodeValue().set(key, nodeId, value);
    }

    default public void setNodeValue(String key, long nodeId, long value) {
        this.nodeValue().set(key, nodeId, value);
    }

    default public void setNodeValue(String key, long nodeId, long[] value) {
        this.nodeValue().set(key, nodeId, value);
    }

    default public void setNodeValue(String key, long nodeId, double[] value) {
        this.nodeValue().set(key, nodeId, value);
    }
}

