/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.beta.pregel.Element;
import org.neo4j.gds.beta.pregel.ImmutableElement;
import org.neo4j.gds.beta.pregel.ImmutablePregelSchema;

@ValueClass
public interface PregelSchema {
    public Set<Element> elements();

    public static class Builder {
        private final Set<Element> elements = new HashSet<Element>();

        public Builder add(String propertyKey, ValueType propertyType) {
            return this.add(propertyKey, propertyType, Visibility.PUBLIC);
        }

        public Builder add(String propertyKey, ValueType propertyType, Visibility visibility) {
            this.elements.add(ImmutableElement.of(propertyKey, propertyType, visibility));
            return this;
        }

        public PregelSchema build() {
            return ImmutablePregelSchema.of(this.elements);
        }
    }

    public static enum Visibility {
        PUBLIC,
        PRIVATE;

    }
}

